% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rba-functions.R
\name{rba_stats}
\alias{rba_stats}
\title{Return data for a specified RBA time series}
\usage{
rba_stats(table_no, pattern, url, update_cache = FALSE, ...)
}
\arguments{
\item{table_no}{Character vector specifying one or more RBA table numbers to download.}

\item{pattern}{Character string or regular expression to be matched.}

\item{url}{Valid URL for RBA dataset (Excel format only).}

\item{update_cache}{Logical expression, if FALSE (default), use the cached list of available
RBA datasets, if TRUE, update the list of available datasets.}

\item{...}{Other arguments to \code{\link{rba_search}}}
}
\value{
data frame in long format
}
\description{
Function to download and return specified RBA time series data.
}
\examples{
  \donttest{
    ## Example - Selecting by table_no
    x <- rba_stats("A1");

    ## Example - Selecting by pattern
    x <- rba_stats(pattern="Liabilities and Assets");
  }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
