% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs-cat-functions.R
\name{abs_cat_releases}
\alias{abs_cat_releases}
\title{Return ABS catalogue table releases}
\usage{
abs_cat_releases(cat_no, include_urls = FALSE)
}
\arguments{
\item{cat_no}{ABS catalogue numbers.}

\item{include_urls}{Include full path URL to specified ABS catalogue releases. Default (FALSE)
does not include release URLs.}
}
\value{
Returns a data frame listing available ABS catalogue releases.
}
\description{
Return list of all releases available for specified ABS catalogue number.
}
\examples{
  \donttest{
    ## List all available quarterly National Accounts tables
    ana_releases <- abs_cat_releases("5206.0");
    ana_release_urls <- abs_cat_releases("5206.0", include_urls=TRUE);
  
    ## List latest available CPI Time Series Spreadsheet tables only
    cpi_releases <- abs_cat_releases("6401.0");
    cpi_release_urls <- abs_cat_releases("6401.0", include_urls=TRUE);
  }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
