% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-outputs.R
\name{register_output}
\alias{register_output}
\alias{register_output_options}
\alias{get_output_options}
\alias{get_output}
\title{Register output and output options}
\usage{
register_output_options(
  outputId,
  ...,
  .opt = list(),
  extras = list(),
  session = shiny::getDefaultReactiveDomain()
)

get_output_options(outputId, session = shiny::getDefaultReactiveDomain())

register_output(
  render_function,
  outputId,
  export_type = c("none", "custom", "pdf", "csv", "3dviewer", "htmlwidget"),
  export_settings = list(),
  quoted = FALSE,
  output_opts = list(),
  session = shiny::getDefaultReactiveDomain()
)

get_output(outputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{outputId}{output ID in the scope of current shiny session}

\item{..., output_opts, .opt}{output options}

\item{extras}{extra information to store}

\item{session}{shiny session instance}

\item{render_function}{shiny render function}

\item{export_type}{type of export file formats supported, options are
\code{'none'} (do not export), \code{'custom'}, \code{'pdf'} (for figures),
\code{'csv'} (for tables), \code{'3dviewer'} (for 'RAVE' 3D viewers),
\code{'htmlwidget'} (for 'HTML' widgets).}

\item{export_settings}{a list of settings, depending on export type; see
'Details'.}

\item{quoted}{whether \code{render_function} is quoted; default is false}
}
\value{
Registered output or output options.
}
\description{
Enable advanced output gadgets such as expanding the output
in another browser window, or downloading the rendered data.
}
\details{
Default shiny output does not provide handlers for downloading the
figures or data, and is often limited to the 'HTML' layouts. 'RAVE' dashboard
provides such mechanisms automatically with few extra configurations.
}
\examples{


if(interactive()) {

library(shiny)
library(ravedash)

rave_id <- paste(sample(c(letters, LETTERS, 0:9), 20, replace = TRUE),
                 collapse = "")

ui <- function(req) {
  query_string <- req$QUERY_STRING
  if(length(query_string) != 1) {
    query_string <- "/"
  }
  query_result <- httr::parse_url(query_string)

  if(!identical(toupper(query_result$query$standalone), "TRUE")) {
    # normal page
    basicPage(
      output_gadget_container(
        plotOutput("plot", brush = shiny::brushOpts("plot__brush")),
      )
    )
  } else {
    # standalone viewer
    uiOutput("viewer")
  }
}

server <- function(input, output, session) {

  bindEvent(
    safe_observe({
      query_string <- session$clientData$url_search
      query_result <- httr::parse_url(query_string)

      if(!identical(toupper(query_result$query$module), "standalone_viewer")) {
        # normal page
        register_rave_session(session = session, .rave_id = rave_id)
        register_output(
          renderPlot({
            plot(1:100, pch = 16)
          }),
          outputId = "plot", export_type = "pdf",
          output_opts = list(brush = shiny::brushOpts("plot__brush"))
        )
        output$plot <- renderPlot({
          input$btn
          plot(rnorm(100), pch = 16)
        })
      } else {
        # standalone viewer
        standalone_viewer(outputId = "plot", rave_id = rave_id)
      }
    }),
    session$clientData$url_search
  )


}

shinyApp(ui, server, options = list(port = 8989))
}

}
