% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rave-export-repository.R
\name{rave_export}
\alias{rave_export}
\alias{rave_export.default}
\alias{rave_export.rave_prepare_subject_raw_voltage_with_epoch}
\alias{rave_export.rave_prepare_subject_voltage_with_epoch}
\alias{rave_export.rave_prepare_power}
\title{Export 'RAVE' data}
\usage{
rave_export(x, path, ...)

\method{rave_export}{default}(x, path, format = c("rds", "yaml", "json"), ...)

\method{rave_export}{rave_prepare_subject_raw_voltage_with_epoch}(x, path, zip = FALSE, ...)

\method{rave_export}{rave_prepare_subject_voltage_with_epoch}(x, path, zip = FALSE, ...)

\method{rave_export}{rave_prepare_power}(x, path, zip = FALSE, ...)
}
\arguments{
\item{x}{R object or 'RAVE' repositories}

\item{path}{path to save to}

\item{...}{passed to other methods}

\item{format}{export format}

\item{zip}{whether to zip the files}
}
\value{
Exported data path
}
\description{
Export portable data for custom analyses.
}
\examples{

x <- "my data"
path <- tempfile()
rave_export(x, path)

readRDS(path)

\dontrun{
  # Needs demo subject
  path <- tempfile()
  x <- prepare_subject_power("demo/DemoSubject")

  # Export power data to path
  rave_export(x, path)
}

}
