% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-resample3d.R
\name{resample_3d_volume}
\alias{resample_3d_volume}
\title{Sample '3D' volume in the world (anatomical \code{'RAS'}) space}
\usage{
resample_3d_volume(
  x,
  new_dim,
  vox2ras_old,
  vox2ras_new = vox2ras_old,
  na_fill = NA
)
}
\arguments{
\item{x}{image (volume) to be sampled: \code{dim(x)} must have length of 3}

\item{new_dim}{target dimension, integers of length 3}

\item{vox2ras_old}{from volume index (column-row-slice) to \code{'RAS'}
(right-anterior-superior) transform: the volume index starts from 0 (C-style)
instead of 1 (R-style) to comply with \code{'NIfTI'} transform.}

\item{vox2ras_new}{the targeting transform from volume index to \code{'RAS'}}

\item{na_fill}{default numbers to fill if a pixel is out of bound; default is
\code{NA} or \code{as.raw(0)} if input \code{x} is raw type}
}
\value{
A newly sampled volume that aligns with \code{x} in the anatomical
\code{'RAS'} coordinate system. The underlying storage mode is the same as
\code{x}
}
\description{
Low-level implementation to sample a '3D' volume into given orientation and
shape via a nearest-neighbor sampler.
}
\examples{


# up-sample and rotate image
x <- array(0, c(9, 9, 9))
x[4:6, 4:6, 4:6] <- 1
vox2ras <- matrix(nrow = 4, byrow = TRUE, c(
  0.7071, -0.7071, 0, 0,
  0.7071, 0.7071, 0, -5.5,
  0, 0, 1, -4,
  0, 0, 0, 1
))

new_vox2ras <- matrix(nrow = 4, byrow = TRUE, c(
  0, 0.5, 0, -4,
  0, 0, -0.5, 4,
  0.5, 0, 0, -4,
  0, 0, 0, 1
))

y <- resample_3d_volume(
  x,
  c(17, 17, 17),
  vox2ras_old = vox2ras,
  vox2ras_new = new_vox2ras,
  na_fill = 0
)


image(y[9,,])



}
