% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_round}
\alias{csg_round}
\title{CSG Round}
\usage{
csg_round(object, radius = 0.1)
}
\arguments{
\item{object}{CSG object.}

\item{radius}{Default `0.1`. Rounding distance.}
}
\value{
List describing the triangle in the scene.
}
\description{
CSG Round
}
\examples{
\donttest{
#Generate a rounded pyramid:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_pyramid(x=-1,y=-0.99,z=1),
                        material=glossy(color="red"))) \%>\% 
  add_object(csg_object(csg_round(csg_pyramid(x=1,y=-0.89)),
                        material=glossy(color="blue"))) \%>\% 
  add_object(csg_object(csg_round(csg_pyramid(x=0,z=-2,y=-0.5), radius=0.5),
                        material=glossy(color="green"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=1,material=light(intensity=50))) \%>\% 
  render_scene(lookfrom=c(-3,4,10), fov=22, 
               lookat=c(0,-0.5,0),clamp_value=10)

#Round a blend of two objects
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_round(csg_combine(
    csg_pyramid(x=-0.5,y=-0.99,z=1.5),
    csg_pyramid(x=0.5,y=-0.99,z=2), operation="blend"), radius=0),
                        material=glossy(color="red"))) \%>\% 
  add_object(csg_object(csg_round(csg_combine(
    csg_pyramid(x=-0.5,y=-0.79,z=-1.5),
    csg_pyramid(x=0.5,y=-0.79,z=-1), operation="blend"), radius=0.2),
                        material=glossy(color="green"))) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=1,material=light(intensity=50))) \%>\% 
  render_scene(lookfrom=c(-3,5,10), fov=22, 
               lookat=c(0,-0.5,0),clamp_value=10)
}
}
