% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{xz_rect_mesh}
\alias{xz_rect_mesh}
\title{XZ Rectangle 3D Model}
\usage{
xz_rect_mesh(
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  material = material_list()
)
}
\arguments{
\item{position}{Default \code{c(0,0,0)}. Position of the mesh.}

\item{scale}{Default \code{c(1,1,1)}. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default \code{c(0,0,0)}. Angle to rotate the mesh.}

\item{pivot_point}{Default \code{c(0,0,0)}. Point around which to rotate the mesh.}

\item{order_rotation}{Default \code{c(1,2,3)}. Order to rotate the axes.}

\item{material}{Default \code{material_list()} (default values). Specify the material of the object.}
}
\value{
List describing the mesh.
}
\description{
XZ Rectangle 3D Model
}
\examples{
if(run_documentation()) {
generate_cornell_mesh() |>
  add_shape(xz_rect_mesh(position = c(555/2, 100, 555/2), scale=200,
             material = material_list(diffuse = "purple"))) |>
  rasterize_scene(light_info = directional_light(c(0,0.5,-1)))
}
if(run_documentation()) {
#Rotate the plane and scale 
generate_cornell_mesh() |>
  add_shape(xz_rect_mesh(position = c(555/2, 100, 555/2), scale=c(200,1,100), angle=c(0,30,0),
             material = material_list(diffuse = "purple"))) |>
  rasterize_scene(light_info = directional_light(c(0,0.5,-1)))
}
}
