% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_mesh.R
\name{construct_mesh}
\alias{construct_mesh}
\title{Manually construct a mesh}
\usage{
construct_mesh(
  vertices,
  indices,
  normals = NULL,
  norm_indices = NULL,
  texcoords = NULL,
  tex_indices = NULL,
  material = material_list()
)
}
\arguments{
\item{vertices}{Nx3 matrix of vertex coordinates..}

\item{indices}{Nx3 integer matrix, where each row defines a triangle using the 
vertices defined in `vertices`.}

\item{normals}{Default `NULL`.  Nx3 matrix of normals.}

\item{norm_indices}{Nx3 integer matrix, where each row defines the normal for a vertex using the 
normals defined in `normals` for the corresponding triangle in `indices`.
Required to be the same number of rows as `indices`.}

\item{texcoords}{Default `NULL`. Nx2 matrix of texture coordinates.}

\item{tex_indices}{Nx3 integer matrix, where each row defines the texture coordinates for a triangle
using the tex coords defined in `texcoors` for the corresponding triangle in `indices`.
Required to be the same number of rows as `indices`.}

\item{material}{Default `material_list()` (default values). Specify the material of the object.}
}
\value{
List  containing mesh info.
}
\description{
Manually construct a mesh
}
\examples{
if(rayvertex:::run_documentation()) {
#Let's construct a mesh from the volcano dataset
#Build the vertex matrix
vertex_list = list()
counter = 1
for(i in 1:nrow(volcano)) {
  for(j in 1:ncol(volcano)) {
    vertex_list[[counter]] = matrix(c(j,volcano[i,j],i), ncol=3)
    counter = counter + 1
  }
}
vertices = do.call(rbind,vertex_list)

#Build the index matrix
index_list = list()
counter = 0
for(i in 1:(nrow(volcano)-1)) {
  for(j in 1:(ncol(volcano)-1)) {
    index_list[[counter+1]] = matrix(c(counter,counter+ncol(volcano),counter+1,
                                       counter+ncol(volcano),counter+ncol(volcano)+1,counter + 1), 
                                     nrow=2, ncol=3, byrow=TRUE)
    counter = counter + 1
  }
  counter = counter + 1
}
indices = do.call(rbind,index_list)

#Construct the mesh
volc_mesh = construct_mesh(vertices = vertices, indices = indices,
                           material = material_list(type="phong", diffuse="darkred", 
                                                    ambient = "darkred", ambient_intensity=0.2))

#Rasterize the scene
rasterize_scene(volc_mesh, lookfrom=c(-50,230,100),fov=60,width=1200,height=1200,
                light_info = directional_light(c(0,1,1)) |>
                  add_light(directional_light(c(1,1,-1))))
}
}
