% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to.R
\name{convert_to}
\alias{convert_to}
\title{Converts B3 messy files to structured formats}
\usage{
convert_to(filename, template = NULL, parse_fields = TRUE, format = "csv")
}
\arguments{
\item{filename}{a string containing a path for the file.}

\item{template}{a string with the template name.}

\item{parse_fields}{a logical indicating if the fields must be parsed.}

\item{format}{output format}
}
\value{
a string with the file path of generated file.
}
\description{
Convert B3 files to structured formats based on the template.
}
\examples{
\dontrun{
f <- system.file("extdata/Indic.txt", package = "rb3")
res <- convert_to(f, output_format = "csv")
res <- convert_to(f, output_format = "json")
}
}
\seealso{
read_marketdata
}
