% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_currencies.R
\name{get_currency}
\alias{get_currency}
\title{Get currency values for a given period}
\usage{
get_currency(
  symbol,
  start_date,
  end_date,
  as = c("tibble", "xts", "data.frame", "text")
)
}
\arguments{
\item{symbol}{currency symbol}

\item{start_date}{time interval initial date}

\item{end_date}{time interval last date}

\item{as}{the object's returning type

The \code{symbol} argument is a three digits character which represents one currency.
The symbols can be obtained with \code{list_currencies}.

The time series date range is defined by \code{start_date} and \code{end_date}.}
}
\value{
The time series with the bid and ask currency rates regarding the given symbol quoted in BRL.
The default returning is a \code{tibble}-fashioned \code{data.frame} with
the three columns: \code{date}, \code{ask} and \code{bid}.
The \code{as} argument also accepts \code{data.frame} to return old fashioned data frames,
\code{xts} to return a xts object with two variables (bid and ask) and \code{text} which returns
the text content download from BCB site.
}
\description{
Given a currency symbol and a time interval (in dates) this function returns the
bid and ask time series of currency rates.
}
\examples{
get_currency("USD", "2017-03-01", "2017-03-10")

}
