% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_currencies.R
\name{get_currency_cross_rates}
\alias{get_currency_cross_rates}
\title{Get currency matrix from BCB}
\usage{
get_currency_cross_rates(date, ref = c("ask", "bid"))
}
\arguments{
\item{date}{reference date}

\item{ref}{reffers to \code{bid} or \code{ask} rates (default \code{ask})

\code{date} is the reference date by which the currency rates must be downloaded.
\code{ref} defaults to \code{ask} and \code{bid} returns all currency cross rates calculated with bid rates.}
}
\value{
A square \code{matrix} with \code{colnames} and \code{rownames} filled with currency symbols
The cells must be read as \code{ROW} in \code{COL}, for example, BRL (row) in USD (column) means Brazilian Reals in American Dollars.
}
\description{
The currency matrix has the currency cross rates for all currencies present in the BCB system.
}
\examples{
\dontrun{
x <- get_currency_cross_rates("2017-03-10")
currencies <- c("USD", "BRL", "AUD", "EUR", "CAD")
x[currencies, currencies]
}
}
