\name{bhl_getpagemetadata}
\alias{bhl_getpagemetadata}
\title{Return metadata about a page.}
\usage{
bhl_getpagemetadata(page = NULL, ocr = FALSE, names = FALSE,
  format = "json", output = "list", key = NULL, callopts = list())
}
\arguments{
  \item{page}{page number to get}

  \item{ocr}{return ocr text of the page (TRUE/FALSE)}

  \item{names}{return the names that appear on the page
  (TRUE/FALSE)}

  \item{format}{either XML ('xml') or JSON ('json') format.
  If output='list', format is forced to equal 'json'}

  \item{output}{Return a list, raw json or xml, or parsed
  data (character).  Default: 'list'}

  \item{key}{your BHL API key, either enter, or loads from
  .Rprofile}

  \item{callopts}{Call options passed on to httr::GET.}
}
\description{
You may choose to include the OCR text and a list of names
found on the page.
}
\examples{
\dontrun{
bhl_getpagemetadata(page=1328690, ocr=TRUE, format='json')
bhl_getpagemetadata(page=1328690, ocr=TRUE, format='xml')
bhl_getpagemetadata(page=1328690, ocr=TRUE, format='xml', output='parsed')
}
}

