% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_tffm}
\alias{rba_jaspar_tffm}
\title{Get a TF flexible models (TFFMs) information}
\usage{
rba_jaspar_tffm(tffm_id, ...)
}
\arguments{
\item{tffm_id}{Character: A TF flexible model (TFFM) Identifier.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains the TFFM's information and annotations.
}
\description{
Using this function you can retrieve details and annotations of
  Transcription Factor flexible models (TFFMs) associated with a TFFM
  ID. If a base ID (i.e. without version suffix) was supplied, the latest
  version will be returned.
}
\section{Corresponding API Resources}{

 "GET "http://jaspar.genereg.net/api/v1/fttm/{tffm_id}/"
}

\examples{
\donttest{
rba_jaspar_tffm("TFFM0056.3")
}

}
\references{
\itemize{
  \item Fornes O, Castro-Mondragon JA, Khan A, et al. JASPAR 2020: update
    of the open-access database of transcription factor binding profiles.
    Nucleic Acids Res. 2019; doi: 10.1093/nar/gkz1001
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR
    data from any programming language. Bioinformatics, 2017, doi:
    10.1093/bioinformatics/btx804
  \item Khan, A. et al. JASPAR 2018: update of the open-access database
    of transcription factor binding profiles and its web framework.
    Nucleic Acids Res. 2018; 46:D260–D266, doi: 10.1093/nar/gkx1126
  \item
  \href{http://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()}
}
\concept{"JASPAR"}
