% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_people_id}
\alias{rba_reactome_people_id}
\title{A person by his identifiers}
\usage{
rba_reactome_people_id(
  person_id,
  authored_pathways = FALSE,
  publications = FALSE,
  attribute_name = NULL,
  ...
)
}
\arguments{
\item{person_id}{Reactome database ID (DbId) or ORCHID ID}

\item{authored_pathways}{Logical: Only return Pathway list authored by the
person? (default = FALSE)}

\item{publications}{Logical: Only return publications list authored by the
person? (Defalt = FALSE)}

\item{attribute_name}{(optional) A Reactome person attribute to return only.
see \href{https://reactome.org/content/schema/Person}{Reactome Data
Schema: person} for available options.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List containing the requested informations of your supplied
  person.
}
\description{
A person by his identifiers
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService"
}

\examples{
\donttest{
rba_reactome_people_id("391309")
}
\donttest{
rba_reactome_people_id(person_id = "391309", authored_pathways = TRUE)
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\seealso{
Other "Reactome Content Service - Person Queries": 
\code{\link{rba_reactome_people_name}()}
}
\concept{"Reactome Content Service - Person Queries"}
