% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_people_id}
\alias{rba_reactome_people_id}
\title{A person by his identifiers}
\usage{
rba_reactome_people_id(
  person_id,
  authored_pathways = FALSE,
  publications = FALSE,
  attribute_name = NULL,
  ...
)
}
\arguments{
\item{person_id}{Reactome database ID (DbId) or ORCHID ID}

\item{authored_pathways}{Logical: Only return Pathway list authored by the
person? (default = FALSE)}

\item{publications}{Logical: Only return publications list authored by the
person? (Defalt = FALSE)}

\item{attribute_name}{(optional) A Reactome person attribute to return only.
see \href{https://reactome.org/content/schema/Person/}{Reactome Data
Schema: person} for available options.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List containing the requested informations of your supplied
  person.
}
\description{
A person by his identifiers
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService"
}

\examples{
\donttest{
rba_reactome_people_id("391309")
}
\donttest{
rba_reactome_people_id(person_id = "391309", authored_pathways = TRUE)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Person Queries": 
\code{\link{rba_reactome_people_name}()}
}
\concept{"Reactome Content Service - Person Queries"}
