% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_coordinates.R
\name{rba_uniprot_coordinates_location}
\alias{rba_uniprot_coordinates_location}
\title{Search UniProt entries by taxonomy and genomic coordinates}
\usage{
rba_uniprot_coordinates_location(
  taxid,
  locations,
  in_range = TRUE,
  feature = FALSE,
  ...
)
}
\arguments{
\item{taxid}{NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}.}

\item{locations}{genomic location formatted as: chromosome:start-end.
(e.g. "Y:17100001-19600000"). If you omit chromosome, it will be interpreted
as any chromosome (e.g. "1-10000").}

\item{in_range}{Only return proteins that are in range.}

\item{feature}{(logical) Get features?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
a list containing UniProt proteins which match the supplied genomic
  location and taxonomy ID.
}
\description{
For more information about how UniProt imports and calculates genomic
  coordinates data, see:
  \cr McGarvey, P. B., Nightingale, A., Luo, J., Huang, H., Martin, M. J.,
  Wu, C., & UniProt Consortium (2019). UniProt genomic mapping for
  deciphering functional effects of missense variants. Human mutation,
  40(6), 694–705. https://doi.org/10.1002/humu.23738
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/coordinates/{taxonomy}/{locations}/feature"
 \cr "GET https://ebi.ac.uk/proteins/api/coordinates/{taxonomy}/{locations}"
}

\examples{
\donttest{
rba_uniprot_coordinates_location(taxid = 9606,
    locations = "Y:17100001-19600000", in_range = TRUE)
}
\donttest{
rba_uniprot_coordinates_location(taxid = 9606,
    locations = "20:39000001", in_range = FALSE)
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Coordinates": 
\code{\link{rba_uniprot_coordinates_search}()},
\code{\link{rba_uniprot_coordinates_sequence}()},
\code{\link{rba_uniprot_coordinates}()}
}
\concept{"UniProt - Coordinates"}
