% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_antigens_search}
\alias{rba_uniprot_antigens_search}
\title{Search Antigens in UniProt}
\usage{
rba_uniprot_antigens_search(
  accession = NULL,
  antigen_sequence = NULL,
  antigen_id = NULL,
  ensembl_id = NULL,
  match_score = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{antigen_sequence}{Protein sequence in the antigenic site.}

\item{antigen_id}{Human Protein Atlas (HPA) antigen ID. You can supply up to
20 IDs.}

\item{ensembl_id}{Ensembl Stable Transcript ID. You can supply up to
20 IDs.}

\item{match_score}{(Numeric) Minimum alignment score for the antigen
sequence and the target protein sequence.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list Where each element correspond to a UniProt protein (search
 hit) and Antigenic features are organized under the "features" sub-list.
}
\description{
UniProt maps Antigenic (Antibody-binding) features from different sources
  to the proteins' sequences. Using this function, you can search for
  Antigenic sequences that has been map to UniProt proteins. You may also
  refine your search with modifiers such as score etc. See
  "Arguments section" for more information.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/antigen"
}

\examples{
\donttest{
rba_uniprot_antigens_search(antigen_id = "HPA001060")
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Antigen": 
\code{\link{rba_uniprot_antigens}()}
}
\concept{"UniProt - Antigen"}
