% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_variation}
\alias{rba_uniprot_variation}
\title{Get natural variants in UniProt by NIH-NCBI SNP database identifier}
\usage{
rba_uniprot_variation(
  id,
  id_type,
  source_type = NULL,
  consequence_type = NULL,
  wild_type = NULL,
  alternative_sequence = NULL,
  location = NULL,
  save_peff = FALSE,
  ...
)
}
\arguments{
\item{id}{An ID which can be either a
\href{https://www.uniprot.org/help/accession_numbers}{UniProt primary or
secondary accession}, NIH-NCBI dbSNP ID or HGVS expression.
\href{https://www.ncbi.nlm.nih.gov/snp/}{NIH-NCBI dbSNP id} or
\href{https://varnomen.hgvs.org/}{HGVS Expression}.}

\item{id_type}{The type of supplied ID argument, one of:
\href{https://www.uniprot.org/help/accession_numbers}{"uniprot"},
\href{https://www.ncbi.nlm.nih.gov/snp/}{"dbsnp"} or
\href{https://varnomen.hgvs.org/}{"hgvs"}}

\item{source_type}{Variation's source type. You can choose up to two of:
"UniProt", "large scale study" and/or "mixed".}

\item{consequence_type}{Variation's consequence type. You can choose up to
two of: "missense", "stop gained" or "stop lost".}

\item{wild_type}{Wild type amino acid. Accepted values are IUPAC
single-letter amino acid (e.g. D for    Aspartic acid) and "*" for stop
codon. You can supply up to 20 values.}

\item{alternative_sequence}{Alternative amino acid. Accepted values are IUPAC
single-letter amino acid (e.g. D for    Aspartic acid) and "*" for stop codon
and "-" for deletion. You can supply up to 20 values.}

\item{location}{A valid amino acid range (e.g. 10-25) within the sequence
range where the variation occurs. You can supply up to 20 values.}

\item{save_peff}{Logical or Character:\itemize{
\item FALSE: (default) Do not save PEFF file, just return as a list object.
\item TRUE: Save as PEFF file to an automatically-generated path.
\item Character string: A valid file path to save the PEFF file.}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list where each element is a list that corresponds to a UniProt
  protein entry.
}
\description{
Retrieve natural variant annotations of a sequence using UniProt protein
  accession, dbSNP or HGVS expression.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/variation/dbsnp/\{dbid\}"
 \cr "GET https://www.ebi.ac.uk/proteins/api/variation/hgvs/\{hgvs\}"
 \cr "GET https://www.ebi.ac.uk/proteins/api/variation/\{accession\}"
}

\examples{
\donttest{
rba_uniprot_variation(id = "rs121434451", id_type = "dbsnp")
}
\donttest{
rba_uniprot_variation(id = "NC_000008.11:g.22119227C>T", id_type = "hgvs")
}
\donttest{
rba_uniprot_variation(id = "O43593", id_type = "uniprot")
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Variation": 
\code{\link{rba_uniprot_variation_search}()}
}
\concept{"UniProt - Variation"}
