% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\name{taxa.names}
\alias{taxa.names}
\title{Get the taxa names.}
\usage{
taxa.names(biom)
}
\arguments{
\item{biom}{A \code{BIOM} object, as returned from \link{read.biom}.}
}
\value{
A character vector of the taxa IDs / names in \code{biom}.
}
\description{
Get the taxa names.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read.biom(infile)
    
    taxa.names(biom) \%>\% head()

}
\seealso{
Other accessor functions: 
\code{\link{counts}()},
\code{\link{info}()},
\code{\link{metadata}()},
\code{\link{nsamples}()},
\code{\link{ntaxa}()},
\code{\link{phylogeny}()},
\code{\link{sample.names}()},
\code{\link{sequences}()},
\code{\link{taxa.ranks}()},
\code{\link{taxonomy}()}
}
\concept{accessor functions}
