% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{subscriptions}
\alias{subscriptions}
\alias{lio_subscriptions}
\alias{lio_subscribed}
\alias{lio_subscribe}
\alias{lio_subscription_update}
\alias{lio_subscription_delete}
\title{Subscriptions}
\usage{
lio_subscriptions(key = NULL, ...)

lio_subscribed(platform, name, key = NULL, ...)

lio_subscribe(platform, name, include_prerelease = FALSE, key = NULL, ...)

lio_subscription_update(platform, name, include_prerelease = FALSE,
  key = NULL, ...)

lio_subscription_delete(platform, name, key = NULL, ...)
}
\arguments{
\item{key}{your Libraries.io API key. See `Auth` section in \pkg{rbraries}
manual file. optional}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}

\item{platform}{(character) a platform. required}

\item{name}{(character) a project name. required}

\item{include_prerelease}{(logical) include prerelease? default: \code{FALSE}}
}
\description{
Subscriptions
}
\examples{
\dontrun{
# authenticated user Libraries.io subscriptions
lio_subscriptions()

# check if you are subscribed to a project
lio_subscribed("rubygems", "webmock")

# subscribe to a project
lio_subscribe(platform = "rubygems", name = "webmock")

# update subscription to a project
lio_subscription_update("rubygems", "webmock")

# delete subscription to a project
lio_subscription_delete("rubygems", "webmock")
}
}
