% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{repos}
\alias{repos}
\alias{lio_repo}
\alias{lio_repo_dependencies}
\alias{lio_repo_projects}
\title{Repositories}
\usage{
lio_repo(owner, name, key = NULL, ...)

lio_repo_dependencies(owner, name, key = NULL, ...)

lio_repo_projects(owner, name, page = 1, per_page = 30, key = NULL, ...)
}
\arguments{
\item{owner}{(character) a github owner name. required}

\item{name}{(character) a project name. required}

\item{key}{your Libraries.io API key. See \code{Auth} section in \pkg{rbraries}
manual file. optional}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}

\item{page}{(integer) page to return. Default: 1}

\item{per_page}{(integer) number of records to return per page.
Maximum: 100. Default: 30}
}
\description{
Repositories
}
\examples{
\dontrun{
# repo summary
lio_repo('ropensci', 'wellknown')

# dependencies
lio_repo_dependencies('ropensci', 'wellknown')
lio_repo_dependencies('gruntjs', 'grunt')

# dependents
lio_repo_projects('gruntjs', 'grunt', per_page = 2)
}
}
