% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.cv.bridge}
\alias{coef.cv.bridge}
\title{Extract coefficients from a 'cv.bridge' object}
\usage{
\method{coef}{cv.bridge}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{A 'cv.bridge' object.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are required.}

\item{...}{Additional arguments for compatibility.}
}
\value{
A vector of coefficients
}
\description{
Extract coefficients from a 'cv.bridge' object.
}
\examples{
set.seed(2019) 
beta <- c(3, 1.5, 0, 0, 2, 0, 0, 0)
p <- length(beta)
beta <- matrix(beta, nrow = p, ncol = 1)

n = 100
X = matrix(rnorm(n*p),n,p)
y = X\%*\%beta + rnorm(n) 

model1 <- cv.bridge(X, y, q = 1)
coef(model1,s='lambda.min')
}
\seealso{
\code{\link{predict.cv.rbridge}}
}
\author{
Bahadir Yuzbasi, Mohammad Arashi and Fikri Akdeniz \cr Maintainer: Bahadir Yuzbasi \email{b.yzb@hotmail.com}
}
