% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/measures.R
\name{pearson.cor}
\alias{pearson.cor}
\title{Measure an impact of the covariates on the response using Pearson correlatio.
This function evaluates the Pearson correlation coefficient between the response \code{y} and each column in the design matrix \code{x} over subsamples in \code{subsamples}.}
\usage{
pearson.cor(x, y, subsamples, ...)
}
\arguments{
\item{x}{Matrix with \code{n} observations of \code{p} covariates in each row.}

\item{y}{Response vector with \code{n} observations.}

\item{subsamples}{Matrix with \code{m} indices of \code{N} subsamples in each column.}

\item{...}{Not in use.}
}
\value{
Numeric \code{p} by \code{N} matrix with Pearson correlations evaluated for each subsample.
}
\description{
Measure an impact of the covariates on the response using Pearson correlatio.
This function evaluates the Pearson correlation coefficient between the response \code{y} and each column in the design matrix \code{x} over subsamples in \code{subsamples}.
}

