% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/membership_to_color.R
\name{membership_to_color}
\alias{membership_to_color}
\title{Compute membership to a color}
\usage{
membership_to_color(caim, target_color, sigma = NULL)
}
\arguments{
\item{caim}{\linkS4class{RasterBrick}. The return of a call to
\code{\link{read_caim}}.}

\item{target_color}{\linkS4class{color}.}

\item{sigma}{Numeric vector of length one. Use \code{NULL} (default) to
estimate it automatically as the euclidean distance between
\code{target_color} and grey in the \emph{CIE L*a*b*} color space.}
}
\value{
It returns an object from the class \linkS4class{RasterBrick} or
  \linkS4class{RasterStack} --this will depend on the input. First layer is
  the membership to the target color. Second layer is the membership to grey.
  Both memberships are calculated with same \code{sigma}.
}
\description{
This function is presented in \insertCite{Diaz2015;textual}{rcaiman}. It
Computes the degree of membership to a color with two Gaussian membership
functions and the dimensions \emph{A} and \emph{B} from the \emph{CIE L*a*b*}
color space. The lightness dimension is not considered in the calculations.
}
\details{
If you use this function in your research, please cite
\insertCite{Diaz2015}{rcaiman}.
}
\examples{
\dontrun{
caim <- read_caim()
caim <- normalize(caim, 0, 255)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
target_color <- colorspace::sRGB(matrix(c(0.529, 0.808, 0.921), ncol = 3))
mem <- membership_to_color(caim, target_color)
plot(mem)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Fuzzy logic functions: 
\code{\link{enhance_caim}()},
\code{\link{local_fuzzy_thresholding}()}
}
\concept{Fuzzy logic functions}
