% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_feature.R
\name{extract_feature}
\alias{extract_feature}
\title{Extract feature}
\usage{
extract_feature(
  r,
  segmentation,
  fun = mean,
  return_raster = TRUE,
  ignore_label_0 = TRUE
)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. Single layer raster.}

\item{segmentation}{\linkS4class{SpatRaster}. The segmentation of \code{r}.}

\item{fun}{A \code{function} that takes a vector as input and returns a
one-length numeric or logical vector as output (e.g. mean).}

\item{return_raster}{Logical vector of length one, see details.}

\item{ignore_label_0}{Logical vector of length one. If this is \code{TRUE},
the segment labeled with \code{0} will be ignored.}
}
\value{
If \code{return_raster} is set to \code{TRUE}, then an object of
class \linkS4class{SpatRaster} with the same pixel dimensions than \code{r}
will be returned. Otherwise, the return is a numeric vector of length equal
to the number of segments found in \code{segmentation}.
}
\description{
Extract features from raster images.
}
\details{
Given a single-layer raster, a segmentation, and a function,
\code{extract_features} will return a numeric vector or a \linkS4class{SpatRaster}
depending on whether the parameter \code{return_raster} is \code{TRUE} or \code{FALSE}. For
the first case, each pixel of each segment will adopt the respective
extracted feature value. For the second case, the return will be a vector of
length equal to the total number of segments. Each value will be obtained by
processing all pixels that belong to a segment with the provided function.
}
\examples{
r <- read_caim()
z <- zenith_image(ncol(r),lens())
a <- azimuth_image(z)
g <- sky_grid_segmentation(z, a, 10)
print(extract_feature(r$Blue, g, return_raster = FALSE))
# plot(extract_feature(r$Blue, g, return_raster = TRUE))
}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_bin}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
