% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sky_points_simple.R
\name{extract_sky_points_simple}
\alias{extract_sky_points_simple}
\title{Extract sky points}
\usage{
extract_sky_points_simple(r, z, a)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically, the
blue channel extracted from a canopy photograph. Please see \code{\link[=read_caim]{read_caim()}}
and \code{\link[=normalize]{normalize()}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link[=azimuth_image]{azimuth_image()}}.}
}
\value{
An object of the class \emph{data.frame} with two columns named
\emph{col} and \emph{row}.
}
\description{
Extract sky points for model fitting
}
\details{
This function will automatically sample sky pixels following this simple
strategy:
\itemize{
\item mask out the region of \code{r} above 15 and below 75 degrees of zenith angle,
\item divide the hemisphere into sectors of 15 degrees each
(see \code{\link[=sectors_segmentation]{sectors_segmentation()}}),
\item search for the maximum digital value in each sector (n = 24),
\item divide the hemisphere into rings of 5 degrees each
(see \code{\link[=rings_segmentation]{rings_segmentation()}},
\item search for the maximum digital value in each ring (n = 12)
\item combine these local maxima (n = 36).
}
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
caim <- read_caim(path, c(1250, 1020) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
r <- gbc(caim$Blue)
sky_points <- extract_sky_points_simple(r, z, a)
plot(r)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
}

}
\seealso{
Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_bin}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
