% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_trend_surface.R
\name{fit_trend_surface}
\alias{fit_trend_surface}
\title{Fit a trend surface to sky digital numbers}
\usage{
fit_trend_surface(r, z, a, bin, filling_source = NULL, np = 6)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically, the
blue channel extracted from a canopy photograph. Please see \code{\link[=read_caim]{read_caim()}}
and \code{\link[=normalize]{normalize()}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{bin}{\linkS4class{SpatRaster}. This should be a preliminary binarization of
\code{r} useful for masking pixels that are very likely pure sky pixels.}

\item{filling_source}{\linkS4class{SpatRaster}. An actual or reconstructed
above-canopy image to complement the sky pixels detected through the gaps
of \code{r}. A photograph taken immediately after or before taking \code{r} under the
open sky with the same equipment and configuration is a very good option
but not recommended under fleeting clouds. The orientation relative to the
North must be the same as for \code{r}. If it is set to \code{NULL} (default), only
sky pixels from \code{r} will be used as input.}

\item{np}{
degree of polynomial surface
}
}
\value{
A list with an object of class \linkS4class{SpatRaster} and of class \code{trls}
(see \code{\link[spatial:surf.ls]{spatial::surf.ls()}}).
}
\description{
Fit a trend surface using \code{\link[spatial:surf.ls]{spatial::surf.ls()}} as workhorse function.
}
\details{
This function is meant to be used after \code{\link[=fit_coneshaped_model]{fit_coneshaped_model()}}.

This method was presented in \insertCite{Diaz2018;textual}{rcaiman}, under
the heading \emph{Estimation of the sky DN as a previous step for our method}. If
you use this function in your research, please cite that paper in addition to
this package (\verb{citation("rcaiman"}).
}
\note{
If an incomplete above-canopy image is available as filling source,
non-sky pixels should be turned \code{NA} or they will be erroneously considered
as sky pixels.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
caim <- normalize(caim, 0, 20847, TRUE)
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)

bin <- ootb_obia(caim, z, a, m, HSV(239, 0.85, 0.5), gamma = NULL)

g <- sky_grid_segmentation(z, a, 10)
sky_points <- extract_sky_points(r, bin, g, dist_to_plant = 5)
plot(bin)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
rl <- extract_rl(r, z, a, sky_points)

model <- fit_coneshaped_model(rl$sky_points)
summary(model$model)
sky_cs <- model$fun(z, a)
persp(terra::aggregate(sky_cs, 10), theta = 90, phi = 45)

sky_s <- fit_trend_surface(r, z, a, bin, sky_cs)
persp(terra::aggregate(sky_s$image, 10), theta = 90, phi = 45)
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=thr_mblt]{thr_mblt()}}

Other Sky Reconstruction Functions: 
\code{\link{cie_sky_model_raster}()},
\code{\link{fit_cie_sky_model}()},
\code{\link{fit_coneshaped_model}()},
\code{\link{fix_reconstructed_sky}()},
\code{\link{interpolate_sky_points}()},
\code{\link{ootb_sky_reconstruction}()}
}
\concept{Sky Reconstruction Functions}
