% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mig_estimate_rc.R
\name{mig_estimate_rc}
\alias{mig_estimate_rc}
\title{Estimate Rogers-Castro migration age schedule}
\usage{
mig_estimate_rc(
  ages,
  net_mig,
  pop,
  pre_working_age,
  working_age,
  retirement,
  post_retirement,
  ...
)
}
\arguments{
\item{ages}{numeric. A vector of integers for ages.}

\item{net_mig}{numeric. A vector of integers for observed age-specific net migrants.}

\item{pop}{numeric. A vector of integers for age-specific population.}

\item{pre_working_age}{logical (TRUE/FALSE). Whether or not to include pre working age component.}

\item{working_age}{logical (TRUE/FALSE). Whether or not to include working age component.}

\item{retirement}{logical (TRUE/FALSE). Whether or not to include retirement age component.}

\item{post_retirement}{logical (TRUE/FALSE). Whether or not to include post retirement age component.}

\item{...}{additional inputs to stan, see ?rstan::stan for details.}
}
\value{
A list of length 3. The first element, \code{pars_df}, is a data frame that provides parameter estimates with 95\% credible intervals.
The second element, \code{fit_df}, is a data frame that shows the data and estimated migration rates at each age.
The third element, \code{check_converge}, is a data frame that provides the R-hat values and effective sample sizes.
}
\description{
Given a set of ages and observed age-specific net migrants, estimate the parameters of a Roger-Castro model migration schedule.
Choose between a 7, 9, 11 or 13 parameter model.
}
\examples{
# define ages, net migrants, and population
ages <- 0:80
net_mig <- c(202,215,167,188,206,189,164,
            158,197,185,176,173,167,198,
            203,237,249,274,319,345,487,
            491,521,505,529,527,521,529,
            507,484,467,439,399,399,380,
            368,310,324,289,292,270,269,
            285,254,245,265,257,258,263,
            253,346,293,332,346,349,355,
            386,346,344,352,331,320,307,
            320,310,258,254,243,256,263,
            183,169,172,160,166,113,132,
            111,130,110,113)
pop <- c(105505,105505,105505,105505,105505,
        106126,106126,106126,106126,106126,
        100104,100104,100104,100104,100104,
        114880,114880,114880,114880,114880,
        136845,136845,136845,136845,136845,
        136582,136582,136582,136582,136582,
        141935,141935,141935,141935,141935,
        134097,134097,134097,134097,134097,
        130769,130769,130769,130769,130769,
        133718,133718,133718,133718,133718,
        154178,154178,154178,154178,154178,
        145386,145386,145386,145386,145386,
        126270,126270,126270,126270,126270,
        108314,108314,108314,108314,108314,
        79827,79827,79827,79827,79827,59556,
        59556,59556,59556,59556,59556)


# fit the model
res <- mig_estimate_rc(ages, net_mig, pop,
                       pre_working_age = TRUE,
                       working_age = TRUE,
                       retirement = TRUE,
                       post_retirement = FALSE,
                       #optional inputs into stan
                       control = list(adapt_delta = 0.95, max_treedepth = 10),
                       iter = 10, chains = 1 #to speed up example
                       )
# plot the results and data
plot(ages, net_mig/pop, ylab = "migration rate", xlab = "age")
lines(ages, res[["fit_df"]]$median, col = "red")
legend("topright", legend=c("data", "fit"), col=c("black", "red"), lty=1, pch = 1)

}
