/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.undo.UndoableEdit;
import javax.vecmath.Point2d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.AddHydrogenEdit;
import org.openscience.cdk.controller.Controller2DModel;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.layout.HydrogenPlacer;
import org.openscience.cdk.tools.HydrogenAdder;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSetManipulator;

public class AddHydrogenAction
extends JCPAction {
    private static final long serialVersionUID = 7696756423842199080L;
    private HydrogenAdder hydrogenAdder = null;
    private IAtomContainer changedAtomsAndBonds = null;
    private HashMap hydrogenAtomMap = null;

    public void actionPerformed(ActionEvent event) {
        this.hydrogenAtomMap = null;
        this.changedAtomsAndBonds = null;
        logger.debug((Object)"Trying to add hydrogen in mode: ", (Object)this.type);
        if (this.hydrogenAdder == null) {
            this.hydrogenAdder = new HydrogenAdder("org.openscience.cdk.tools.ValencyChecker");
        }
        if (this.jcpPanel.getJChemPaintModel() != null) {
            JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
            IChemModel model = jcpmodel.getChemModel();
            IChemObject object = this.getSource(event);
            if (object != null) {
                if (object instanceof Atom) {
                    logger.debug((Object)"Adding hydrogens to this specific atom");
                    Atom atom = (Atom)object;
                    this.addHydrogenToOneAtom(ChemModelManipulator.getRelevantAtomContainer((IChemModel)model, (IAtom)atom), atom);
                } else if (object instanceof ChemModel) {
                    logger.debug((Object)"Adding hydrogens to all atoms");
                    this.addHydrogenToAllAtoms(model);
                } else {
                    logger.error((Object)"Can only add hydrogens to Atom's");
                }
            } else {
                logger.debug((Object)"Adding hydrogens to all atoms");
                this.addHydrogenToAllAtoms(model);
            }
            AddHydrogenEdit edit = null;
            if (this.type.equals("explicit")) {
                edit = new AddHydrogenEdit(model, this.changedAtomsAndBonds);
            } else if (this.type.equals("implicit")) {
                edit = new AddHydrogenEdit(model, this.hydrogenAtomMap);
            } else if (this.type.equals("allimplicit")) {
                edit = new AddHydrogenEdit(model, this.hydrogenAtomMap);
            }
            this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
            jcpmodel.fireChange();
            Controller2DModel controllerModel = this.jcpPanel.getJChemPaintModel().getControllerModel();
            if (this.type.equals("implicit")) {
                if (!controllerModel.getAutoUpdateImplicitHydrogens()) {
                    controllerModel.setAutoUpdateImplicitHydrogens(true);
                } else {
                    controllerModel.setAutoUpdateImplicitHydrogens(false);
                }
            }
        }
    }

    private void addHydrogenToAllAtoms(IChemModel model) {
        IMoleculeSet som = model.getMoleculeSet();
        IReactionSet sor = model.getReactionSet();
        if (som != null) {
            this.addHydrogenToAllMolecules(som);
        } else if (sor != null) {
            logger.debug((Object)"#reactions ", sor.getReactionCount());
            som = ReactionSetManipulator.getAllMolecules((IReactionSet)sor);
            logger.debug((Object)"Found molecules: ", som.getMoleculeCount());
            this.addHydrogenToAllMolecules(som);
        }
    }

    private void addHydrogenToAllMolecules(IMoleculeSet som) {
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        Controller2DModel controllerModel = jcpmodel.getControllerModel();
        try {
            Iterator mols = som.molecules();
            while (mols.hasNext()) {
                IMolecule molecule = (IMolecule)mols.next();
                if (molecule != null) {
                    int j;
                    if (this.type.equals("implicit")) {
                        if (!controllerModel.getAutoUpdateImplicitHydrogens()) {
                            this.hydrogenAtomMap = this.hydrogenAdder.addImplicitHydrogensToSatisfyValency((IAtomContainer)molecule);
                            continue;
                        }
                        for (j = 0; j < molecule.getAtomCount(); ++j) {
                            logger.debug((Object)"Checking atom: ", j);
                            molecule.getAtom(j).setHydrogenCount(0);
                        }
                        continue;
                    }
                    if (this.type.equals("explicit")) {
                        double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)molecule, (HashMap)jcpmodel.getRendererModel().getRenderingCoordinates());
                        if (Double.isNaN(bondLength)) {
                            logger.warn((Object)"Could not determine average bond length from structure!");
                            bondLength = controllerModel.getBondPointerLength();
                        }
                        this.changedAtomsAndBonds = this.hydrogenAdder.addExplicitHydrogensToSatisfyValency((IAtomContainer)molecule);
                        HydrogenPlacer hPlacer = new HydrogenPlacer();
                        hPlacer.placeHydrogens2D((IAtomContainer)molecule, bondLength, jcpmodel.getRendererModel().getRenderingCoordinates());
                        IAtomContainer atomCon = ChemModelManipulator.getAllInOneContainer((IChemModel)jcpmodel.getChemModel());
                        for (int k = 0; k < atomCon.getAtomCount(); ++k) {
                            IAtom currentAtom = atomCon.getAtom(k);
                            if (jcpmodel.getRendererModel().getRenderingCoordinate(currentAtom) == null) continue;
                            currentAtom.setPoint2d(new Point2d(jcpmodel.getRendererModel().getRenderingCoordinate(currentAtom)));
                        }
                        continue;
                    }
                    if (!this.type.equals("allimplicit")) continue;
                    for (j = 0; j < molecule.getAtomCount(); ++j) {
                        IAtom atom = molecule.getAtom(j);
                        logger.debug((Object)"Checking atom: ", j);
                        if (!atom.getSymbol().equals("H")) continue;
                        logger.debug((Object)"Atom is a hydrogen");
                        molecule.removeAtomAndConnectedElectronContainers(atom);
                        if (j - 1 == molecule.getAtomCount()) continue;
                        --j;
                    }
                    this.hydrogenAtomMap = this.hydrogenAdder.addImplicitHydrogensToSatisfyValency((IAtomContainer)molecule);
                    continue;
                }
                logger.error((Object)"Molecule is null! Cannot add hydrogens!");
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            logger.error((Object)"Error while adding hydrogen: ", (Object)exc.getMessage());
            logger.debug((Object)exc);
        }
    }

    private void addHydrogenToOneAtom(IAtomContainer container, Atom atom) {
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        Controller2DModel controllerModel = jcpmodel.getControllerModel();
        try {
            if (this.type.equals("implicit")) {
                int[] hydrogens = this.hydrogenAdder.addImplicitHydrogensToSatisfyValency(container, (IAtom)atom);
                this.hydrogenAtomMap.put(atom, hydrogens);
            } else if (this.type.equals("explicit")) {
                double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)container, (HashMap)jcpmodel.getRendererModel().getRenderingCoordinates());
                if (Double.isNaN(bondLength)) {
                    logger.warn((Object)"Could not determine average bond length from structure!");
                    bondLength = controllerModel.getBondPointerLength();
                }
                this.changedAtomsAndBonds = this.hydrogenAdder.addExplicitHydrogensToSatisfyValency(container, (IAtom)atom, container);
                HydrogenPlacer hPlacer = new HydrogenPlacer();
                hPlacer.placeHydrogens2D(container, (IAtom)atom, bondLength);
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Error while adding hydrogen: ", (Object)exc.getMessage());
            logger.debug((Object)exc);
        }
    }
}

