/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.PTDialog;
import org.openscience.cdk.applications.swing.PeriodicTablePanel;
import org.openscience.cdk.controller.Controller2DModel;
import org.openscience.cdk.event.ICDKChangeListener;

public class ChemAction
extends JCPAction {
    private static final long serialVersionUID = -399343341314165265L;
    private PTDialog dialog = null;

    public void actionPerformed(ActionEvent e) {
        ((JButton)this.jcpPanel.lastAction.get(0)).setBackground(Color.LIGHT_GRAY);
        ((JComponent)e.getSource()).setBackground(Color.GRAY);
        this.jcpPanel.lastAction.set(0, (JComponent)e.getSource());
        logger.debug((Object)"ChemAction performed!");
        String s = e.getActionCommand();
        String type = s.substring(s.indexOf("@") + 1);
        logger.info((Object)"  type  ", (Object)type);
        logger.debug((Object)"  source ", e.getSource());
        JChemPaintModel jcpm = this.jcpPanel.getJChemPaintModel();
        if (jcpm != null) {
            Controller2DModel c2dm = jcpm.getControllerModel();
            if (type.equals("bond")) {
                c2dm.setDrawMode(0);
                c2dm.setDrawElement("C");
            } else if (type.equals("select")) {
                c2dm.setDrawMode(2);
            } else if (type.equals("move")) {
                c2dm.setDrawMode(1);
            } else if (type.equals("select")) {
                c2dm.setDrawMode(2);
            } else if (type.equals("eraser")) {
                c2dm.setDrawMode(3);
            } else if (type.equals("element")) {
                if (this.dialog == null) {
                    this.dialog = new PTDialog(new PTDialogChangeListener(c2dm));
                }
                this.dialog.pack();
                this.dialog.setVisible(true);
                c2dm.setDrawMode(4);
            } else if (type.equals("symbol")) {
                c2dm.setDrawMode(5);
            } else if (type.equals("triangle")) {
                c2dm.setDrawMode(6);
                c2dm.setRingSize(3);
                c2dm.setDrawElement("C");
            } else if (type.equals("square")) {
                c2dm.setDrawMode(6);
                c2dm.setRingSize(4);
                c2dm.setDrawElement("C");
            } else if (type.equals("pentagon")) {
                c2dm.setDrawMode(6);
                c2dm.setRingSize(5);
                c2dm.setDrawElement("C");
            } else if (type.equals("hexagon")) {
                c2dm.setDrawMode(6);
                c2dm.setRingSize(6);
                c2dm.setDrawElement("C");
            } else if (type.equals("heptagon")) {
                c2dm.setDrawMode(6);
                c2dm.setRingSize(7);
                c2dm.setDrawElement("C");
            } else if (type.equals("octagon")) {
                c2dm.setDrawMode(6);
                c2dm.setRingSize(8);
                c2dm.setDrawElement("C");
            } else if (type.equals("benzene")) {
                c2dm.setDrawMode(17);
                c2dm.setRingSize(6);
                c2dm.setDrawElement("C");
            } else if (type.equals("cleanup")) {
                c2dm.setDrawMode(7);
            } else if (type.equals("flip_H")) {
                c2dm.setDrawMode(8);
            } else if (type.equals("flip_V")) {
                c2dm.setDrawMode(9);
            } else if (type.equals("rotation")) {
                c2dm.setDrawMode(10);
            } else if (type.equals("up_bond")) {
                c2dm.setDrawMode(11);
                c2dm.setDrawElement("C");
            } else if (type.equals("down_bond")) {
                c2dm.setDrawMode(12);
                c2dm.setDrawElement("C");
            } else if (type.equals("normalize")) {
                c2dm.setDrawMode(13);
            } else if (type.equals("plus")) {
                c2dm.setDrawMode(15);
            } else if (type.equals("minus")) {
                c2dm.setDrawMode(16);
            } else if (type.equals("lasso")) {
                c2dm.setDrawMode(14);
            } else if (type.equals("map")) {
                c2dm.setDrawMode(18);
            } else if (type.equals("enterelement")) {
                c2dm.setDrawMode(19);
            }
        }
        this.jcpPanel.stateChanged(new ChangeEvent(this));
        if (jcpm != null) {
            jcpm.fireChange();
        }
    }

    class PTDialogChangeListener
    implements ICDKChangeListener {
        Controller2DModel model;

        public PTDialogChangeListener(Controller2DModel model) {
            this.model = model;
        }

        public void stateChanged(EventObject event) {
            JCPAction.logger.debug((Object)"Element change signaled...");
            if (event.getSource() instanceof PeriodicTablePanel) {
                PeriodicTablePanel source = (PeriodicTablePanel)event.getSource();
                String symbol = source.getSelectedElement().getSymbol();
                JCPAction.logger.debug((Object)"Setting drawing element to: ", (Object)symbol);
                this.model.setDrawElement(symbol);
                ChemAction.this.dialog.setVisible(false);
                ChemAction.this.dialog = null;
            } else {
                JCPAction.logger.warn((Object)"Unkown source for event: ", (Object)event.getSource().getClass().getName());
            }
        }
    }
}

