/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import com.sun.media.jai.codec.JPEGEncodeParam;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.SaveAsAction;
import org.openscience.cdk.applications.jchempaint.io.JCPExportFileFilter;
import org.openscience.cdk.applications.jchempaint.io.JCPFileView;
import org.openscience.cdk.interfaces.IChemModel;

public class ExportAction
extends SaveAsAction {
    private static final long serialVersionUID = -3287152749914283054L;
    private FileFilter currentFilter = null;

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.jcpPanel.getCurrentWorkDirectory());
        JCPExportFileFilter.addChoosableFileFilters(chooser);
        if (this.currentFilter != null) {
            chooser.setFileFilter(this.currentFilter);
        }
        chooser.setFileView(new JCPFileView());
        int returnVal = chooser.showSaveDialog(this.jcpPanel);
        String type = null;
        this.currentFilter = chooser.getFileFilter();
        if (returnVal == 0) {
            type = ((JCPExportFileFilter)this.currentFilter).getType();
            File outFile = chooser.getSelectedFile();
            if (type.equals("svg")) {
                try {
                    JChemPaintModel jcpm = this.jcpPanel.getJChemPaintModel();
                    ChemModel model = (ChemModel)jcpm.getChemModel();
                    this.saveAsSVG((IChemModel)model, outFile);
                }
                catch (Exception exc) {
                    String error = "Error while writing file: " + exc.getMessage();
                    logger.error((Object)error);
                    logger.debug((Object)exc);
                    JOptionPane.showMessageDialog(this.jcpPanel, error);
                }
            } else {
                Image awtImage = this.jcpPanel.takeSnapshot();
                String filename = outFile.toString();
                logger.debug((Object)"Creating binary image: ", (Object)filename);
                RenderedOp image = JAI.create((String)"AWTImage", (Object)awtImage);
                if (type.equals("bmp")) {
                    JAI.create((String)"filestore", (RenderedImage)image, (Object)filename, (Object)"BMP", null);
                } else if (type.equals("tiff")) {
                    JAI.create((String)"filestore", (RenderedImage)image, (Object)filename, (Object)"TIFF", null);
                } else if (type.equals("jpg")) {
                    JAI.create((String)"filestore", (RenderedImage)image, (Object)filename, (Object)"JPEG", (Object)new JPEGEncodeParam());
                } else if (type.equals("png")) {
                    JAI.create((String)"filestore", (RenderedImage)image, (Object)filename, (Object)"PNG", null);
                } else {
                    JAI.create((String)"filestore", (RenderedImage)image, (Object)filename, (Object)"PNG", null);
                }
                logger.debug((Object)"Binary image saved to: ", (Object)filename);
            }
        }
        this.jcpPanel.setCurrentWorkDirectory(chooser.getCurrentDirectory());
    }
}

