/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Viewer;

class Bond {
    Atom atom1;
    Atom atom2;
    short order;
    short mad;
    short colix;
    int shapeVisibilityFlags;
    static final int myVisibilityFlag = Viewer.getShapeVisibilityFlag(1);

    Bond(Atom atom1, Atom atom2, short order, short mad, short colix) {
        if (atom1 == null) {
            throw new NullPointerException();
        }
        if (atom2 == null) {
            throw new NullPointerException();
        }
        this.atom1 = atom1;
        this.atom2 = atom2;
        if (atom1.getElementNumber() == 16 && atom2.getElementNumber() == 16) {
            order = (short)(order | 0x20);
        }
        if (order == 4) {
            order = (short)5;
        }
        this.order = order;
        this.colix = colix;
        this.setMad(mad);
    }

    boolean isCovalent() {
        return (this.order & 3) != 0;
    }

    boolean isHydrogen() {
        return (this.order & 0x3C0) != 0;
    }

    boolean isStereo() {
        return (this.order & 0x18) != 0;
    }

    boolean isAromatic() {
        return (this.order & 4) != 0;
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    void setMad(short mad) {
        boolean isVisible;
        boolean wasVisible = this.mad != 0;
        boolean bl = isVisible = mad != 0;
        if (wasVisible != isVisible) {
            this.atom1.addDisplayedBond(myVisibilityFlag, isVisible);
            this.atom2.addDisplayedBond(myVisibilityFlag, isVisible);
        }
        this.mad = mad;
        this.setShapeVisibility(myVisibilityFlag, isVisible);
    }

    final void setShapeVisibility(int shapeVisibilityFlag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= shapeVisibilityFlag) : (this.shapeVisibilityFlags &= ~shapeVisibilityFlag);
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void setTranslucent(boolean isTranslucent) {
        this.colix = Graphics3D.setTranslucent(this.colix, isTranslucent);
    }

    boolean isTranslucent() {
        return Graphics3D.isColixTranslucent(this.colix);
    }

    void setOrder(short order) {
        this.order = order;
    }

    Atom getAtom1() {
        return this.atom1;
    }

    Atom getAtom2() {
        return this.atom2;
    }

    float getRadius() {
        return (float)this.mad / 2000.0f;
    }

    short getOrder() {
        return this.order;
    }

    String getOrderName() {
        switch (this.order) {
            case 1: {
                return "single";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "triple";
            }
            case 4: {
                return "aromatic";
            }
        }
        if ((this.order & 0x3C0) != 0) {
            return "hbond";
        }
        return "unknown";
    }

    short getColix1() {
        return Graphics3D.inheritColix(this.colix, this.atom1.colixAtom);
    }

    int getArgb1() {
        return this.atom1.group.chain.frame.viewer.getColixArgb(this.getColix1());
    }

    short getColix2() {
        return Graphics3D.inheritColix(this.colix, this.atom2.colixAtom);
    }

    int getArgb2() {
        return this.atom1.group.chain.frame.viewer.getColixArgb(this.getColix2());
    }

    Atom getOtherAtom(Atom thisAtom) {
        return this.atom1 == thisAtom ? this.atom2 : (this.atom2 == thisAtom ? this.atom1 : null);
    }

    Hashtable getPublicProperties() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("atomIndexA", new Integer(this.atom1.atomIndex));
        ht.put("atomIndexB", new Integer(this.atom2.atomIndex));
        ht.put("argbA", new Integer(this.getArgb1()));
        ht.put("argbB", new Integer(this.getArgb2()));
        ht.put("order", this.getOrderName());
        ht.put("radius", new Double(this.getRadius()));
        ht.put("modelIndex", new Integer(this.atom1.modelIndex));
        ht.put("xA", new Double(this.atom1.x));
        ht.put("yA", new Double(this.atom1.y));
        ht.put("zA", new Double(this.atom1.z));
        ht.put("xB", new Double(this.atom2.x));
        ht.put("yB", new Double(this.atom2.y));
        ht.put("zB", new Double(this.atom2.z));
        return ht;
    }
}

