/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;
import org.jmol.api.JmolAdapter;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.viewer.MonitorInputStream;
import org.jmol.viewer.Viewer;

class FileManager {
    Viewer viewer;
    JmolAdapter modelAdapter;
    private String openErrorMessage;
    URL appletDocumentBase = null;
    URL appletCodeBase = null;
    String appletProxy = null;
    String defaultDirectory = null;
    private String nameAsGiven;
    private String fullPathName;
    String fileName;
    String inlineData;
    boolean isInline;
    boolean isDOM;
    private File file;
    private FileOpenThread fileOpenThread;
    private FilesOpenThread filesOpenThread;
    private DOMOpenThread aDOMOpenThread;
    final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};

    FileManager(Viewer viewer, JmolAdapter modelAdapter) {
        this.viewer = viewer;
        this.modelAdapter = modelAdapter;
    }

    void openFile(String name) {
        this.openFile(name, null);
    }

    void openFile(String name, int[] params) {
        String sp = "";
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                sp = sp + "," + params[i];
            }
        }
        Logger.info("\nFileManager.openFile(" + name + sp + ")");
        this.nameAsGiven = name;
        this.fileName = null;
        this.fullPathName = null;
        this.openErrorMessage = null;
        this.classifyName(name);
        if (this.openErrorMessage != null) {
            Logger.error("openErrorMessage=" + this.openErrorMessage);
            return;
        }
        this.fileOpenThread = new FileOpenThread(this.fullPathName, name, params);
        this.fileOpenThread.run();
    }

    void openFiles(String modelName, String[] names) {
        String[] fullPathNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.nameAsGiven = names[i];
            this.fileName = null;
            this.fullPathName = null;
            this.openErrorMessage = null;
            this.classifyName(names[i]);
            if (this.openErrorMessage != null) {
                Logger.error("openErrorMessage=" + this.openErrorMessage);
                return;
            }
            fullPathNames[i] = this.fullPathName;
        }
        this.fileName = this.nameAsGiven = modelName;
        this.fullPathName = this.nameAsGiven;
        this.inlineData = "";
        this.isInline = false;
        this.isDOM = false;
        this.filesOpenThread = new FilesOpenThread(fullPathNames, names);
        this.filesOpenThread.run();
    }

    void openStringInline(String strModel) {
        this.openStringInline(strModel, null);
    }

    void openStringInline(String strModel, int[] params) {
        String sp = "";
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                sp = sp + "," + params[i];
            }
        }
        Logger.info("FileManager.openStringInline(" + sp + ")");
        this.openErrorMessage = null;
        this.fileName = "string";
        this.fullPathName = "string";
        this.inlineData = strModel;
        this.isInline = true;
        this.isDOM = false;
        this.fileOpenThread = params == null ? new FileOpenThread(this.fullPathName, new StringReader(strModel)) : new FileOpenThread(this.fullPathName, new StringReader(strModel), params);
        this.fileOpenThread.run();
    }

    void openDOM(Object DOMNode) {
        this.openErrorMessage = null;
        this.fileName = "JSNode";
        this.fullPathName = "JSNode";
        this.inlineData = "";
        this.isInline = false;
        this.isDOM = true;
        this.aDOMOpenThread = new DOMOpenThread(DOMNode);
        this.aDOMOpenThread.run();
    }

    void openReader(String fullPathName, String name, Reader reader) {
        this.openErrorMessage = null;
        this.fullPathName = fullPathName;
        this.fileName = name;
        this.fileOpenThread = new FileOpenThread(fullPathName, reader);
        this.fileOpenThread.run();
    }

    boolean isGzip(InputStream is) throws Exception {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117;
    }

    boolean isCompoundDocument(InputStream is) throws Exception {
        byte[] abMagic = new byte[8];
        is.mark(9);
        int countRead = is.read(abMagic, 0, 8);
        is.reset();
        return countRead == 8 && abMagic[0] == -48 && abMagic[1] == -49 && abMagic[2] == 17 && abMagic[3] == -32 && abMagic[4] == -95 && abMagic[5] == -79 && abMagic[6] == 26 && abMagic[7] == -31;
    }

    String getFileAsString(String name) {
        Logger.info("FileManager.getFileAsString(" + name + ")");
        Object t = this.getInputStreamOrErrorMessageFromName(name);
        if (t instanceof String) {
            return "Error:" + t;
        }
        try {
            String line;
            BufferedInputStream bis;
            FilterInputStream is = bis = new BufferedInputStream((InputStream)t, 8192);
            if (this.isCompoundDocument(is)) {
                CompoundDocument doc = new CompoundDocument(name, bis);
                return "" + doc.getAllData();
            }
            if (this.isGzip(is)) {
                is = new GZIPInputStream(bis);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuffer sb = new StringBuffer(8192);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            return "" + sb;
        }
        catch (Exception ioe) {
            return ioe.getMessage();
        }
    }

    Object waitForClientFileOrErrorMessage() {
        Object clientFile = null;
        if (this.fileOpenThread != null) {
            clientFile = this.fileOpenThread.clientFile;
            if (this.fileOpenThread.errorMessage != null) {
                this.openErrorMessage = this.fileOpenThread.errorMessage;
            } else if (clientFile == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.fileOpenThread = null;
        } else if (this.filesOpenThread != null) {
            clientFile = this.filesOpenThread.clientFile;
            if (this.filesOpenThread.errorMessage != null) {
                this.openErrorMessage = this.filesOpenThread.errorMessage;
            } else if (clientFile == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
        } else if (this.aDOMOpenThread != null) {
            clientFile = this.aDOMOpenThread.clientFile;
            if (this.aDOMOpenThread.errorMessage != null) {
                this.openErrorMessage = this.aDOMOpenThread.errorMessage;
            } else if (clientFile == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.aDOMOpenThread = null;
        }
        if (this.openErrorMessage != null) {
            return this.openErrorMessage;
        }
        return clientFile;
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        if (this.appletDocumentBase == null) {
            return "";
        }
        return this.appletDocumentBase.toString();
    }

    void setAppletContext(URL documentBase, URL codeBase, String jmolAppletProxy) {
        this.appletDocumentBase = documentBase;
        Logger.info("appletDocumentBase=" + documentBase);
        this.appletCodeBase = codeBase;
        this.appletProxy = jmolAppletProxy;
    }

    void setAppletProxy(String appletProxy) {
        this.appletProxy = appletProxy == null || appletProxy.length() == 0 ? null : appletProxy;
    }

    void setDefaultDirectory(String defaultDirectory) {
        if (this.appletDocumentBase == null) {
            return;
        }
        this.defaultDirectory = defaultDirectory == null || defaultDirectory.length() == 0 ? null : defaultDirectory;
    }

    void dumpDocumentBase(String documentBase) {
        Logger.info("dumpDocumentBase:" + documentBase);
        Object inputStreamOrError = this.getInputStreamOrErrorMessageFromName(documentBase);
        if (inputStreamOrError == null) {
            Logger.error("?Que? ?null?");
        } else if (inputStreamOrError instanceof String) {
            Logger.error("Error:" + inputStreamOrError);
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStreamOrError));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    Logger.info(line);
                }
                br.close();
            }
            catch (Exception ex) {
                Logger.error("exception caught:" + ex);
            }
        }
    }

    private void classifyName(String name) {
        if (name == null) {
            return;
        }
        if (this.appletDocumentBase != null) {
            try {
                if (this.defaultDirectory != null && name.indexOf(":/") < 0) {
                    name = this.defaultDirectory + "/" + name;
                }
                URL url = new URL(this.appletDocumentBase, name);
                this.fullPathName = url.toString();
                this.fileName = this.fullPathName.substring(this.fullPathName.lastIndexOf(47) + 1, this.fullPathName.length());
            }
            catch (MalformedURLException e) {
                this.openErrorMessage = e.getMessage();
            }
            return;
        }
        for (int i = 0; i < this.urlPrefixes.length; ++i) {
            if (!name.startsWith(this.urlPrefixes[i])) continue;
            try {
                URL url = new URL(name);
                this.fullPathName = url.toString();
                this.fileName = this.fullPathName.substring(this.fullPathName.lastIndexOf(47) + 1, this.fullPathName.length());
            }
            catch (MalformedURLException e) {
                this.openErrorMessage = e.getMessage();
            }
            return;
        }
        this.file = new File(name);
        this.fullPathName = this.file.getAbsolutePath();
        this.fileName = this.file.getName();
    }

    Object getInputStreamOrErrorMessageFromName(String name) {
        String errorMessage = null;
        int iurlPrefix = this.urlPrefixes.length;
        while (--iurlPrefix >= 0 && !name.startsWith(this.urlPrefixes[iurlPrefix])) {
        }
        boolean isURL = iurlPrefix >= 0;
        boolean isApplet = this.appletDocumentBase != null;
        try {
            InputStream in;
            int length;
            if (isApplet || isURL) {
                if (isApplet && isURL && this.appletProxy != null) {
                    name = this.appletProxy + "?url=" + URLEncoder.encode(name, "utf-8");
                } else if (!isURL && this.defaultDirectory != null) {
                    name = this.defaultDirectory + "/" + name;
                }
                URL url = isApplet ? new URL(this.appletDocumentBase, name) : new URL(name);
                Logger.info("FileManager opening " + url.toString());
                URLConnection conn = url.openConnection();
                length = conn.getContentLength();
                in = conn.getInputStream();
            } else {
                Logger.info("FileManager opening " + name);
                File file = new File(name);
                length = (int)file.length();
                in = new FileInputStream(file);
            }
            return new MonitorInputStream(in, length);
        }
        catch (Exception e) {
            errorMessage = "" + e;
            return errorMessage;
        }
    }

    Object getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String name) {
        Object t = this.getInputStreamOrErrorMessageFromName(name);
        if (t instanceof String) {
            return t;
        }
        try {
            BufferedInputStream bis;
            FilterInputStream is = bis = new BufferedInputStream((InputStream)t, 8192);
            if (this.isCompoundDocument(is)) {
                CompoundDocument doc = new CompoundDocument(name, bis);
                return this.getBufferedReaderForString("" + doc.getAllData());
            }
            if (this.isGzip(is)) {
                is = new GZIPInputStream(bis);
            }
            return new BufferedReader(new InputStreamReader(is));
        }
        catch (Exception ioe) {
            return ioe.getMessage();
        }
    }

    class FilesOpenThread
    implements Runnable {
        boolean terminated;
        String errorMessage;
        String[] fullPathNameInThread;
        String[] nameAsGivenInThread;
        Object clientFile;
        Reader[] reader;

        FilesOpenThread(String[] fullPathName, String[] nameAsGiven) {
            this.fullPathNameInThread = fullPathName;
            this.nameAsGivenInThread = nameAsGiven;
        }

        FilesOpenThread(String[] name, Reader[] reader) {
            this.fullPathNameInThread = name;
            this.nameAsGivenInThread = name;
            this.reader = reader;
        }

        public void run() {
            if (this.reader != null) {
                this.openReader(this.reader);
            } else {
                InputStream[] istream = new InputStream[this.nameAsGivenInThread.length];
                for (int i = 0; i < this.nameAsGivenInThread.length; ++i) {
                    Object t = FileManager.this.getInputStreamOrErrorMessageFromName(this.nameAsGivenInThread[i]);
                    if (!(t instanceof InputStream)) {
                        this.errorMessage = t == null ? "error opening:" + this.nameAsGivenInThread : (String)t;
                        this.terminated = true;
                        return;
                    }
                    istream[i] = (InputStream)t;
                }
                this.openInputStream(this.fullPathNameInThread, istream);
            }
            if (this.errorMessage != null) {
                Logger.error("error opening " + this.fullPathNameInThread + "\n" + this.errorMessage);
            }
            this.terminated = true;
        }

        private void openInputStream(String[] fullPathName, InputStream[] istream) {
            Reader[] zistream = new Reader[istream.length];
            for (int i = 0; i < istream.length; ++i) {
                BufferedInputStream bis;
                BufferedInputStream is = bis = new BufferedInputStream(istream[i], 8192);
                try {
                    if (FileManager.this.isCompoundDocument(is)) {
                        CompoundDocument doc = new CompoundDocument(fullPathName[i], bis);
                        zistream[i] = new StringReader("" + doc.getAllData());
                        continue;
                    }
                    if (FileManager.this.isGzip(is)) {
                        zistream[i] = new InputStreamReader(new GZIPInputStream(bis));
                        continue;
                    }
                    zistream[i] = new InputStreamReader(is);
                    continue;
                }
                catch (Exception ioe) {
                    this.errorMessage = ioe.getMessage();
                    return;
                }
            }
            this.openReader(zistream);
        }

        private void openReader(Reader[] reader) {
            BufferedReader[] buffered = new BufferedReader[reader.length];
            for (int i = 0; i < reader.length; ++i) {
                buffered[i] = new BufferedReader(reader[i]);
            }
            Object clientFile = FileManager.this.modelAdapter.openBufferedReaders(this.fullPathNameInThread, buffered);
            if (clientFile instanceof String) {
                this.errorMessage = (String)clientFile;
            } else {
                this.clientFile = clientFile;
            }
        }
    }

    class FileOpenThread
    implements Runnable {
        boolean terminated;
        String errorMessage;
        String fullPathNameInThread;
        String nameAsGivenInThread;
        Object clientFile;
        Reader reader;
        int[] params;

        FileOpenThread(String fullPathName, String nameAsGiven) {
            this.fullPathNameInThread = fullPathName;
            this.nameAsGivenInThread = nameAsGiven;
            this.params = null;
        }

        FileOpenThread(String fullPathName, String nameAsGiven, int[] params) {
            this.fullPathNameInThread = fullPathName;
            this.nameAsGivenInThread = nameAsGiven;
            this.params = params;
        }

        FileOpenThread(String name, Reader reader, int[] params) {
            this.nameAsGivenInThread = this.fullPathNameInThread = name;
            this.reader = reader;
            this.params = params;
        }

        FileOpenThread(String name, Reader reader) {
            this.nameAsGivenInThread = this.fullPathNameInThread = name;
            this.reader = reader;
        }

        public void run() {
            if (this.reader != null) {
                this.openReader(this.reader);
            } else {
                Object t = FileManager.this.getInputStreamOrErrorMessageFromName(this.nameAsGivenInThread);
                if (!(t instanceof InputStream)) {
                    this.errorMessage = t == null ? "error opening:" + this.nameAsGivenInThread : (String)t;
                } else {
                    this.openInputStream(this.fullPathNameInThread, FileManager.this.fileName, (InputStream)t);
                }
            }
            if (this.errorMessage != null) {
                Logger.error("error opening " + this.fullPathNameInThread + "\n" + this.errorMessage);
            }
            this.terminated = true;
        }

        private void openInputStream(String fullPathName, String fileName, InputStream istream) {
            BufferedInputStream bis;
            FilterInputStream is = bis = new BufferedInputStream(istream, 8192);
            try {
                if (FileManager.this.isCompoundDocument(is)) {
                    CompoundDocument doc = new CompoundDocument(fullPathName, bis);
                    this.openReader(new StringReader("" + doc.getAllData()));
                    return;
                }
                if (FileManager.this.isGzip(is)) {
                    is = new GZIPInputStream(bis);
                }
                this.openReader(new InputStreamReader(is));
            }
            catch (Exception ioe) {
                this.errorMessage = ioe.getMessage();
            }
        }

        private void openReader(Reader reader) {
            Object clientFile = FileManager.this.modelAdapter.openBufferedReader(this.fullPathNameInThread, new BufferedReader(reader), this.params);
            if (clientFile instanceof String) {
                this.errorMessage = (String)clientFile;
            } else {
                this.clientFile = clientFile;
            }
        }
    }

    class DOMOpenThread
    implements Runnable {
        boolean terminated;
        String errorMessage;
        Object aDOMNode;
        Object clientFile;

        DOMOpenThread(Object DOMNode) {
            this.aDOMNode = DOMNode;
        }

        public void run() {
            this.clientFile = FileManager.this.modelAdapter.openDOMReader(this.aDOMNode);
            this.errorMessage = null;
            this.terminated = true;
        }
    }
}

