/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;
import org.jmol.viewer.NucleicPolymer;
import org.jmol.viewer.Trace;

class TraceRenderer
extends MpsRenderer {
    boolean isNucleicPolymer;
    int myVisibilityFlag;
    int monomerCount;
    Monomer[] monomers;
    Point3i[] leadMidpointScreens;
    Point3f[] leadMidpoints;

    TraceRenderer() {
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer, int myVisibilityFlag) {
        this.myVisibilityFlag = myVisibilityFlag;
        Trace.Tchain tchain = (Trace.Tchain)mpspolymer;
        this.isNucleicPolymer = tchain.polymer instanceof NucleicPolymer;
        this.monomerCount = tchain.monomerCount;
        if (this.monomerCount == 0) {
            return;
        }
        this.monomers = tchain.monomers;
        this.leadMidpoints = tchain.leadMidpoints;
        this.leadMidpointScreens = this.calcScreenLeadMidpoints(this.monomerCount, this.leadMidpoints);
        this.render1Chain(tchain.mads, tchain.colixes);
        this.viewer.freeTempScreens(this.leadMidpointScreens);
    }

    void render1Chain(short[] mads, short[] colixes) {
        int i = this.monomerCount;
        while (--i >= 0) {
            if ((this.monomers[i].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(this.monomers[i].getLeadAtomIndex())) continue;
            short colix = Graphics3D.inheritColix(colixes[i], this.monomers[i].getLeadAtom().colixAtom);
            this.renderRopeSegment(colix, mads, i, this.monomerCount, this.monomers, this.leadMidpointScreens, null);
        }
    }
}

