/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class RingGenerator
extends BasicBondGenerator {
    private IGeneratorParameter<Boolean> showAromaticity = new ShowAromaticity();
    private IGeneratorParameter<Boolean> cdkStyleAromaticity = new CDKStyleAromaticity();
    private IGeneratorParameter<Double> ringProportion = new RingProportion();
    private Collection<IRing> painted_rings = new HashSet<IRing>();

    @Override
    public IRenderingElement generateRingElements(IBond bond, IRing ring, RendererModel model) {
        if (this.ringIsAromatic(ring) && this.showAromaticity.getValue().booleanValue()) {
            ElementGroup pair = new ElementGroup();
            if (this.cdkStyleAromaticity.getValue().booleanValue()) {
                pair.add(this.generateBondElement(bond, IBond.Order.SINGLE, model));
                super.setOverrideColor(Color.LIGHT_GRAY);
                pair.add(this.generateInnerElement(bond, ring, model));
                super.setOverrideColor(null);
            } else {
                pair.add(this.generateBondElement(bond, IBond.Order.SINGLE, model));
                if (!this.painted_rings.contains(ring)) {
                    this.painted_rings.add(ring);
                    pair.add(this.generateRingRingElement(bond, ring, model));
                }
            }
            return pair;
        }
        return super.generateRingElements(bond, ring, model);
    }

    private IRenderingElement generateRingRingElement(IBond bond, IRing ring, RendererModel model) {
        Point2d c = GeometryTools.get2DCenter((IAtomContainer)ring);
        double[] minmax = GeometryTools.getMinMax((IAtomContainer)ring);
        double width = minmax[2] - minmax[0];
        double height = minmax[3] - minmax[1];
        double radius = Math.min(width, height) * this.ringProportion.getValue();
        return new OvalElement(c.x, c.y, radius, false, this.getColorForBond(bond, model));
    }

    private boolean ringIsAromatic(IRing ring) {
        boolean isAromatic = true;
        for (IAtom atom : ring.atoms()) {
            if (atom.getFlag(5)) continue;
            isAromatic = false;
            break;
        }
        if (!isAromatic) {
            isAromatic = true;
            for (IBond b : ring.bonds()) {
                if (b.getFlag(5)) continue;
                return false;
            }
        }
        return isAromatic;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.cdkStyleAromaticity, this.showAromaticity, this.ringProportion);
    }

    public static class RingProportion
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 0.35;
        }
    }

    public static class CDKStyleAromaticity
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class ShowAromaticity
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }
}

