/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

public class LonePairGenerator
implements IGenerator<IAtomContainer> {
    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        ElementGroup group = new ElementGroup();
        double SCREEN_RADIUS = 1.0;
        double SCREEN_SEPARATION = 2.5;
        Color RADICAL_COLOR = Color.BLACK;
        double ATOM_RADIUS = (Double)model.getParameter(BasicAtomGenerator.AtomRadius.class).getValue();
        double scale = (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double modelAtomRadius = ATOM_RADIUS / scale;
        double modelPointRadius = 1.0 / scale;
        double modelSeparation = 2.5 / scale;
        for (ILonePair lp : ac.lonePairs()) {
            IAtom atom = lp.getAtom();
            Point2d p = atom.getPoint2d();
            int align = GeometryTools.getBestAlignmentForLabelXY((IAtomContainer)ac, (IAtom)atom);
            double rx = p.x;
            double ry = p.y;
            double dx = 0.0;
            double dy = 0.0;
            if (align == 1) {
                rx += modelAtomRadius;
                dy += modelSeparation;
            } else if (align == -1) {
                rx -= modelAtomRadius;
                dy += modelSeparation;
            } else if (align == 2) {
                ry -= modelAtomRadius;
                dx += modelSeparation;
            } else if (align == -2) {
                ry += modelAtomRadius;
                dx += modelSeparation;
            }
            group.add(new OvalElement(rx + dx, ry + dy, modelPointRadius, true, RADICAL_COLOR));
            group.add(new OvalElement(rx - dx, ry - dy, modelPointRadius, true, RADICAL_COLOR));
        }
        return group;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Collections.emptyList();
    }
}

