/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SetSymbol
extends AbstractEdit {
    IAtom oldAtom;
    String symbol;
    String oldSymbol;
    IAtom newAtom;

    public static SetSymbol setSymbol(IAtom atom, String symbol) {
        return new SetSymbol(atom, symbol);
    }

    private SetSymbol(IAtom atom, String symbol) {
        this.oldAtom = atom;
        this.symbol = symbol;
    }

    @Override
    public void redo() {
        this.oldSymbol = this.oldAtom.getSymbol();
        if (this.oldAtom instanceof IPseudoAtom) {
            this.newAtom = (IAtom)this.oldAtom.getBuilder().newInstance(IAtom.class, new Object[]{this.symbol, this.oldAtom.getPoint2d()});
            AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)this.model, (IAtom)this.oldAtom, (IAtom)this.newAtom);
            this.updateHydrogenCount(this.newAtom);
        } else {
            this.oldAtom.setSymbol(this.symbol);
            this.updateHydrogenCount(this.oldAtom);
        }
    }

    @Override
    public void undo() {
        if (this.newAtom != null) {
            AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)this.model, (IAtom)this.newAtom, (IAtom)this.oldAtom);
        } else {
            this.oldAtom.setSymbol(this.oldSymbol);
        }
        this.updateHydrogenCount(this.oldAtom);
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return SetSymbol.changed(Changed.Properties);
    }
}

