/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class GenerateFragments {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(GenerateFragments.class);
    private List murckoFragments = null;
    private List ringFragments = null;
    private List linkerFragments = null;
    private IRingSet ringSetsMolecule = null;
    private boolean sidechainHetatoms = true;
    private boolean exocyclicDoubleBonds = true;
    private boolean smilesToUpperCase = false;

    public void generateRingFragments(IMolecule molecule) {
        this.ringFragments = new ArrayList();
        this.ringSetsMolecule = new SSSRFinder(molecule).findSSSR();
        if (this.ringSetsMolecule.getAtomContainerCount() > 0) {
            this.ringFragments = RingPartitioner.partitionRings(this.ringSetsMolecule);
        }
    }

    public void generateMurckoFragments(IMolecule molecule, boolean sidechainHetatoms, boolean exocyclicDoubleBonds, int minimumRingSize) throws CDKException {
        int f;
        this.murckoFragments = new Vector();
        this.linkerFragments = new Vector();
        this.sidechainHetatoms = sidechainHetatoms;
        this.exocyclicDoubleBonds = exocyclicDoubleBonds;
        IAtom firstRingAtom = null;
        IAtom secondRingAtom = null;
        IAtomContainer firstRingAtomContainer = null;
        IAtomContainer secondRingAtomContainer = null;
        IAtomContainer firstRingSubstituents = null;
        IAtomContainer secondRingSubstituents = null;
        AtomContainer path = null;
        IMolecule murckoFragment = null;
        IMolecule linkerFragment = null;
        Vector<IAtomContainer> tmpRingFragments = new Vector<IAtomContainer>();
        this.generateRingFragments(molecule);
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            molecule.getAtom(i).setFlag(1, false);
        }
        for (f = 0; f < this.ringFragments.size(); ++f) {
            firstRingAtomContainer = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            IRingSet ringSet = (IRingSet)this.ringFragments.get(f);
            for (int i = 0; i < ringSet.getAtomContainerCount(); ++i) {
                firstRingAtomContainer.add(ringSet.getAtomContainer(i));
            }
            if (firstRingAtomContainer.getAtomCount() < minimumRingSize) continue;
            tmpRingFragments.add(firstRingAtomContainer);
            for (int g = 0; g < firstRingAtomContainer.getAtomCount(); ++g) {
                molecule.getAtom(molecule.getAtomNumber(firstRingAtomContainer.getAtom(g))).setFlag(1, true);
            }
        }
        if (tmpRingFragments.size() > 1) {
            for (f = 0; f < tmpRingFragments.size() - 1; ++f) {
                firstRingAtomContainer = (IAtomContainer)tmpRingFragments.get(f);
                for (int g = f + 1; g < tmpRingFragments.size(); ++g) {
                    secondRingAtomContainer = (IAtomContainer)tmpRingFragments.get(g);
                    block6: for (int h = 0; h < firstRingAtomContainer.getAtomCount(); ++h) {
                        firstRingAtom = firstRingAtomContainer.getAtom(h);
                        firstRingSubstituents = this.getPossibleLinkerSubstituents(firstRingAtom, molecule, firstRingAtomContainer);
                        if (firstRingSubstituents.getAtomCount() <= 0) continue;
                        for (int i = 0; i < firstRingSubstituents.getAtomCount(); ++i) {
                            if (firstRingSubstituents.getAtom(i).getFlag(1) && secondRingAtomContainer.contains(firstRingSubstituents.getAtom(i))) {
                                murckoFragment = new Molecule();
                                murckoFragment = this.addFragments(firstRingAtomContainer, murckoFragment, molecule);
                                murckoFragment = this.addFragments(secondRingAtomContainer, murckoFragment, molecule);
                                murckoFragment = this.addFragmentBonds(murckoFragment, molecule);
                                linkerFragment = new Molecule();
                                linkerFragment.addAtom(firstRingAtom);
                                linkerFragment.addAtom(firstRingSubstituents.getAtom(i));
                                linkerFragment = this.addFragmentBonds(linkerFragment, molecule);
                                this.linkerFragments.add(linkerFragment);
                                this.murckoFragments.add(murckoFragment);
                                continue block6;
                            }
                            for (int j = 0; j < secondRingAtomContainer.getAtomCount(); ++j) {
                                secondRingAtom = secondRingAtomContainer.getAtom(j);
                                secondRingSubstituents = this.getPossibleLinkerSubstituents(secondRingAtom, molecule, secondRingAtomContainer);
                                if (secondRingSubstituents.getAtomCount() <= 0) continue;
                                for (int k = 0; k < secondRingSubstituents.getAtomCount(); ++k) {
                                    path = new AtomContainer();
                                    this.resetFlags(molecule);
                                    PathTools.depthFirstTargetSearch(molecule, firstRingSubstituents.getAtom(i), secondRingSubstituents.getAtom(k), path);
                                    if (firstRingSubstituents.getAtom(i) == secondRingSubstituents.getAtom(k)) {
                                        path.addAtom(firstRingSubstituents.getAtom(i));
                                    }
                                    if (!this.checkPath(firstRingAtom, secondRingAtom, path) || path.getAtomCount() <= 0) continue;
                                    murckoFragment = new Molecule();
                                    if (!path.contains(firstRingSubstituents.getAtom(i))) {
                                        path.addAtom(firstRingSubstituents.getAtom(i));
                                    }
                                    if (!path.contains(secondRingSubstituents.getAtom(k))) {
                                        path.addAtom(secondRingSubstituents.getAtom(k));
                                    }
                                    if (!(linkerFragment = new Molecule(murckoFragment = this.addPathFragments(path, murckoFragment, molecule))).contains(firstRingAtom)) {
                                        linkerFragment.addAtom(firstRingAtom);
                                    }
                                    if (!linkerFragment.contains(secondRingAtom)) {
                                        linkerFragment.addAtom(secondRingAtom);
                                    }
                                    linkerFragment = this.addFragmentBonds(linkerFragment, molecule);
                                    murckoFragment = this.addFragments(firstRingAtomContainer, murckoFragment, molecule);
                                    murckoFragment = this.addFragments(secondRingAtomContainer, murckoFragment, molecule);
                                    murckoFragment = this.addFragmentBonds(murckoFragment, molecule);
                                    this.linkerFragments.add(linkerFragment);
                                    this.murckoFragments.add(murckoFragment);
                                }
                            }
                        }
                    }
                }
            }
        } else if (tmpRingFragments.size() == 1) {
            murckoFragment = new Molecule();
            murckoFragment = this.addFragments((IRingSet)this.ringFragments.get(0), murckoFragment, molecule);
            murckoFragment = this.addFragmentBonds(murckoFragment, molecule);
            this.murckoFragments.add(murckoFragment);
        }
    }

    private IMolecule addPathFragments(IAtomContainer addAtomContainer, IMolecule targetMolecule, IMolecule mainMolecule) {
        IAtomContainer ringAtomContainer = null;
        List<IAtom> atoms = null;
        block0: for (int i = 0; i < addAtomContainer.getAtomCount(); ++i) {
            int j;
            if (addAtomContainer.getAtom(i).getFlag(1) && !targetMolecule.contains(addAtomContainer.getAtom(i))) {
                for (j = 0; j < this.ringFragments.size(); ++j) {
                    ringAtomContainer = addAtomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                    IRingSet ringSet = (IRingSet)this.ringFragments.get(j);
                    for (int k = 0; k < ringSet.getAtomContainerCount(); ++k) {
                        ringAtomContainer.add(ringSet.getAtomContainer(k));
                    }
                    if (!ringAtomContainer.contains(addAtomContainer.getAtom(i))) continue;
                    targetMolecule = this.addFragments(ringAtomContainer, targetMolecule, mainMolecule);
                    continue block0;
                }
                continue;
            }
            if ((this.sidechainHetatoms || this.exocyclicDoubleBonds) && !targetMolecule.contains(addAtomContainer.getAtom(i))) {
                atoms = mainMolecule.getConnectedAtomsList(addAtomContainer.getAtom(i));
                targetMolecule.addAtom(addAtomContainer.getAtom(i));
                for (j = 0; j < atoms.size(); ++j) {
                    IAtom atom = atoms.get(j);
                    if (!(!this.sidechainHetatoms || addAtomContainer.getAtom(i).getFlag(1) || atom.getSymbol().equals("C") || atom.getSymbol().equals("H") || targetMolecule.contains(atom))) {
                        targetMolecule.addAtom(atom);
                    }
                    if (!this.exocyclicDoubleBonds || mainMolecule.getBond(atom, addAtomContainer.getAtom(i)).getOrder() == IBond.Order.SINGLE || targetMolecule.contains(atom)) continue;
                    targetMolecule.addAtom(atom);
                }
                continue;
            }
            if (targetMolecule.contains(addAtomContainer.getAtom(i))) continue;
            targetMolecule.addAtom(addAtomContainer.getAtom(i));
        }
        return targetMolecule;
    }

    private IMolecule addFragmentBonds(IMolecule targetMolecule, IMolecule mainMolecule) {
        int firstAtomNumber = 0;
        int secondAtomNumber = 0;
        for (int i = 0; i < targetMolecule.getAtomCount() - 1; ++i) {
            for (int j = i + 1; j < targetMolecule.getAtomCount(); ++j) {
                if (mainMolecule.getBond(targetMolecule.getAtom(i), targetMolecule.getAtom(j)) == null) continue;
                firstAtomNumber = targetMolecule.getAtomNumber(targetMolecule.getAtom(i));
                secondAtomNumber = targetMolecule.getAtomNumber(targetMolecule.getAtom(j));
                targetMolecule.addBond(firstAtomNumber, secondAtomNumber, mainMolecule.getBond(targetMolecule.getAtom(i), targetMolecule.getAtom(j)).getOrder());
                if (!mainMolecule.getBond(targetMolecule.getAtom(i), targetMolecule.getAtom(j)).getFlag(5)) continue;
                targetMolecule.getBond(targetMolecule.getAtom(firstAtomNumber), targetMolecule.getAtom(secondAtomNumber)).setFlag(5, true);
            }
        }
        return targetMolecule;
    }

    private IMolecule addFragments(IRingSet ringSet, IMolecule targetMolecule, IMolecule mainMolecule) {
        for (int i = 0; i < ringSet.getAtomContainerCount(); ++i) {
            this.addFragments(ringSet.getAtomContainer(i), targetMolecule, mainMolecule);
        }
        return targetMolecule;
    }

    private IMolecule addFragments(IAtomContainer addAtomContainer, IMolecule targetMolecule, IMolecule mainMolecule) {
        for (int i = 0; i < addAtomContainer.getAtomCount(); ++i) {
            targetMolecule.addAtom(addAtomContainer.getAtom(i));
            targetMolecule.addAtom(addAtomContainer.getAtom(i));
            List<IAtom> atoms = mainMolecule.getConnectedAtomsList(addAtomContainer.getAtom(i));
            for (IAtom atom : atoms) {
                if (!this.exocyclicDoubleBonds || mainMolecule.getBond(atom, addAtomContainer.getAtom(i)).getOrder() == IBond.Order.SINGLE || targetMolecule.contains(atom)) continue;
                targetMolecule.addAtom(atom);
            }
        }
        return targetMolecule;
    }

    private boolean checkPath(IAtom firstRingAtom, IAtom secondRingAtom, IAtomContainer path) {
        return !path.contains(firstRingAtom) && !path.contains(secondRingAtom);
    }

    private IAtomContainer getPossibleLinkerSubstituents(IAtom ringAtom, IMolecule molecule, IAtomContainer ringSystem) {
        List<IAtom> atoms = molecule.getConnectedAtomsList(ringAtom);
        AtomContainer substituents = new AtomContainer();
        for (IAtom atom : atoms) {
            if (ringSystem.contains(atom) || atom.getSymbol().equals("H")) continue;
            substituents.addAtom(atom);
        }
        return substituents;
    }

    private boolean zeroAtomLinker(IAtom firstRingAtom, IAtom secondRingAtom, IMolecule molecule) {
        List<IAtom> atoms = molecule.getConnectedAtomsList(firstRingAtom);
        return atoms.contains(secondRingAtom);
    }

    public String[] getMurckoFrameworksAsSmileArray() {
        String[] murckoFragmentsmiles = new String[]{};
        if (this.murckoFragments != null) {
            murckoFragmentsmiles = new String[this.murckoFragments.size()];
            for (int i = 0; i < this.murckoFragments.size(); ++i) {
                try {
                    IMolecule mol = (IMolecule)this.murckoFragments.get(i);
                    if (ConnectivityChecker.isConnected(mol)) {
                        SmilesGenerator sg = new SmilesGenerator();
                        if (this.smilesToUpperCase) {
                            murckoFragmentsmiles[i] = sg.createSMILES(mol).toUpperCase();
                            continue;
                        }
                        murckoFragmentsmiles[i] = sg.createSMILES(mol);
                        continue;
                    }
                    logger.debug("ERROR in getMurckoFrameworksAsSmileArray due to:Molecule is not connected");
                    continue;
                }
                catch (Exception e) {
                    logger.error("ERROR in getMurckoFrameworksAsSmileArray due to:" + e.toString());
                    logger.debug(e);
                }
            }
        }
        return murckoFragmentsmiles;
    }

    public String[] getRingFragmentsAsSmileArray() {
        String[] ringFragmentSmiles = new String[]{};
        if (this.ringFragments != null) {
            ringFragmentSmiles = new String[this.ringFragments.size()];
            for (int i = 0; i < this.ringFragments.size(); ++i) {
                try {
                    IMolecule mol = (IMolecule)this.ringFragments.get(i);
                    SmilesGenerator sg = new SmilesGenerator();
                    if (this.smilesToUpperCase) {
                        ringFragmentSmiles[i] = sg.createSMILES(mol).toUpperCase();
                        continue;
                    }
                    ringFragmentSmiles[i] = sg.createSMILES(mol);
                    continue;
                }
                catch (Exception e) {
                    logger.error("ERROR in smile generation due to:" + e.toString());
                }
            }
        }
        return ringFragmentSmiles;
    }

    public String[] getLinkerFragmentsAsSmileArray() {
        String[] linkerFragmentSmiles = new String[]{};
        if (this.linkerFragments != null) {
            linkerFragmentSmiles = new String[this.linkerFragments.size()];
            for (int i = 0; i < this.linkerFragments.size(); ++i) {
                try {
                    IMolecule mol = (IMolecule)this.linkerFragments.get(i);
                    SmilesGenerator sg = new SmilesGenerator();
                    if (this.smilesToUpperCase) {
                        linkerFragmentSmiles[i] = sg.createSMILES(mol).toUpperCase();
                        continue;
                    }
                    linkerFragmentSmiles[i] = sg.createSMILES(mol);
                    continue;
                }
                catch (Exception e) {
                    logger.error("ERROR in smile generation due to:" + e.toString());
                }
            }
        }
        return linkerFragmentSmiles;
    }

    private void resetFlags(IMolecule molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            molecule.getAtom(i).setFlag(4, false);
        }
    }

    public List getMurckoFrameworks() {
        return this.murckoFragments;
    }

    public List getRingFragments() {
        return this.ringFragments;
    }

    public List getLinkerFragments() {
        return this.linkerFragments;
    }

    public boolean isSmilesToUpperCase() {
        return this.smilesToUpperCase;
    }

    public void setSmilesToUpperCase(boolean smilesToUpperCase) {
        this.smilesToUpperCase = smilesToUpperCase;
    }
}

