/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractPoint3;
import org.xmlcml.cml.element.CMLLine3;
import org.xmlcml.cml.element.CMLPlane3;
import org.xmlcml.cml.element.CMLTransform3;
import org.xmlcml.cml.element.CMLVector3;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class CMLPoint3
extends AbstractPoint3 {
    public static final String NS = "cml:point3";

    public CMLPoint3() {
    }

    public CMLPoint3(CMLPoint3 old) {
        super(old);
    }

    public Node copy() {
        return new CMLPoint3(this);
    }

    public CMLElement makeElementInContext(Element parent) {
        return new CMLPoint3();
    }

    public void finishMakingElement(Element parent) throws RuntimeException {
        double[] array = this.getXMLContent();
        if (array == null) {
            throw new RuntimeException("point must not be empty");
        }
        if (array.length != 3) {
            throw new RuntimeException("point must have 3 double components");
        }
    }

    public CMLPoint3(double[] array) {
        this.setXYZ3(array);
    }

    public CMLPoint3(Point3 p) {
        this(p.getArray());
    }

    public CMLPoint3(double x, double y, double z) {
        this();
        this.setXMLContent(new double[]{x, y, z});
    }

    public Point3 getEuclidPoint3() throws RuntimeException {
        return new Point3(this.getXMLContent());
    }

    public void setXYZ3(double[] xyz3) {
        if (xyz3.length != 3) {
            throw new RuntimeException("xyz3 must be of length 3");
        }
        this.setXMLContent(xyz3);
    }

    public double[] getXYZ3() {
        return this.getXMLContent();
    }

    public boolean isEqualTo(CMLPoint3 p) {
        Point3 peucl3 = this.getEuclidPoint3();
        return peucl3 == null ? null : Boolean.valueOf(peucl3.isEqualTo(p.getEuclidPoint3()));
    }

    public boolean isEqualTo(CMLPoint3 p, double eps) {
        double[] xyz = this.getXYZ3();
        double[] xyzP = p.getXYZ3();
        return Util.isEqual(xyz, xyzP, eps);
    }

    public boolean equalsCrystallographically(CMLPoint3 p) {
        Point3 peucl3 = this.getEuclidPoint3();
        return peucl3 == null ? false : peucl3.equalsCrystallographically(p.getEuclidPoint3());
    }

    public boolean isInvariant(CMLTransform3 t3, boolean translate) {
        Point3 peucl3 = this.getEuclidPoint3();
        return peucl3 == null ? false : peucl3.isInvariant(t3.getEuclidTransform3(), translate);
    }

    public CMLVector3 subtract(CMLPoint3 p2) {
        Point3 peucl3 = this.getEuclidPoint3();
        Vector3 v = peucl3 == null ? null : peucl3.subtract(p2.getEuclidPoint3());
        return peucl3 == null ? null : CMLVector3.createCMLVector3(v);
    }

    public CMLPoint3 plus(CMLPoint3 p) {
        Point3 peucl3 = this.getEuclidPoint3();
        Point3 pp = peucl3 == null ? null : peucl3.plus(p.getEuclidPoint3());
        return pp == null ? null : new CMLPoint3(pp);
    }

    public void plusEquals(CMLPoint3 pt) {
        Point3 peucl3 = this.getEuclidPoint3();
        if (peucl3 != null) {
            peucl3.plusEquals(pt.getEuclidPoint3());
            this.setXMLContent(peucl3.getArray());
        }
    }

    public CMLPoint3 plus(CMLVector3 v) {
        Point3 peucl3 = this.getEuclidPoint3();
        Point3 vv = peucl3 == null ? null : peucl3.plus(v.getEuclidVector3());
        return vv == null ? null : new CMLPoint3(vv);
    }

    public void plusEquals(CMLVector3 v) {
        Point3 peucl3 = this.getEuclidPoint3();
        if (peucl3 != null) {
            peucl3.plusEquals(v.getEuclidVector3());
            this.setXMLContent(peucl3.getArray());
        }
    }

    public CMLPoint3 subtract(CMLVector3 v) {
        Point3 pp = this.getEuclidPoint3().subtract(v.getEuclidVector3());
        return pp == null ? null : new CMLPoint3(pp);
    }

    public void subtractEquals(CMLPoint3 pt) {
        Point3 peucl3 = this.getEuclidPoint3();
        peucl3.subtractEquals(pt.getEuclidPoint3());
        this.setXMLContent(peucl3.getArray());
    }

    public void subtractEquals(CMLVector3 vec3) {
        Point3 peucl3 = this.getEuclidPoint3();
        peucl3.subtractEquals(vec3.getEuclidVector3());
        this.setXMLContent(peucl3.getArray());
    }

    public CMLPoint3 multiplyBy(double f) {
        Point3 pp = this.getEuclidPoint3().multiplyBy(f);
        return pp == null ? null : new CMLPoint3(pp);
    }

    public void multiplyEquals(double f) {
        Point3 peucl3 = this.getEuclidPoint3();
        peucl3.multiplyEquals(f);
        this.setXMLContent(peucl3.getArray());
    }

    public CMLPoint3 divideBy(double f) throws RuntimeException {
        Point3 pp = this.getEuclidPoint3().divideBy(f);
        return pp == null ? null : new CMLPoint3(pp);
    }

    public double elementAt(int n) throws RuntimeException {
        Point3 peucl3 = this.getEuclidPoint3();
        try {
            return peucl3.elementAt(n);
        }
        catch (EuclidRuntimeException e) {
            throw new RuntimeException("" + e);
        }
    }

    public void setElementAt(int n, double d) {
        Point3 peucl3 = this.getEuclidPoint3();
        try {
            peucl3.setElementAt(n, d);
        }
        catch (EuclidRuntimeException e) {
            throw new RuntimeException("" + e);
        }
        this.setXMLContent(peucl3.getArray());
    }

    public CMLPoint3 transform(CMLTransform3 t) {
        Point3 pp = this.getEuclidPoint3().transform(t.getEuclidTransform3());
        return pp == null ? null : new CMLPoint3(pp);
    }

    public double getDistanceFromOrigin() {
        Point3 peucl3 = this.getEuclidPoint3();
        return peucl3 == null ? Double.NaN : peucl3.getDistanceFromOrigin();
    }

    public double getSquaredDistanceFromPoint(CMLPoint3 p2) {
        Point3 peucl3 = this.getEuclidPoint3();
        return peucl3.getSquaredDistanceFromPoint(p2.getEuclidPoint3());
    }

    public double getDistanceFromPoint(CMLPoint3 p2) {
        Point3 peucl3 = this.getEuclidPoint3();
        return peucl3.getDistanceFromPoint(p2.getEuclidPoint3());
    }

    public double distanceFromPlane(CMLPlane3 pl) {
        Point3 peucl3 = this.getEuclidPoint3();
        return peucl3 == null ? Double.NaN : peucl3.distanceFromPlane(pl.getEuclidPlane3());
    }

    public CMLPoint3 getClosestPointOnLine(CMLLine3 l) {
        Point3 pp = this.getEuclidPoint3().getClosestPointOnLine(l.getEuclidLine3());
        return pp == null ? null : new CMLPoint3(pp);
    }

    public boolean isOnLine(CMLLine3 l) {
        return this.getEuclidPoint3().isOnLine(l.getEuclidLine3());
    }

    public boolean isOnPlane(CMLPlane3 pl) {
        return this.getEuclidPoint3().isOnPlane(pl.getEuclidPlane3());
    }

    public double distanceFromLine(CMLLine3 l) {
        double d = this.getEuclidPoint3().distanceFromLine(l.getEuclidLine3());
        return d;
    }

    public CMLPoint3 getMidPoint(CMLPoint3 p2) {
        Point3 pp = this.getEuclidPoint3().getMidPoint(p2.getEuclidPoint3());
        return pp == null ? null : new CMLPoint3(pp);
    }

    public Angle getAngle(CMLPoint3 p2, CMLPoint3 p3) {
        return Point3.getAngle(this.getEuclidPoint3(), p2.getEuclidPoint3(), p3.getEuclidPoint3());
    }

    public double getTorsion(CMLPoint3 p2, CMLPoint3 p3, CMLPoint3 p4) {
        Point3 peucl3 = this.getEuclidPoint3();
        double torsion = Double.NaN;
        if (peucl3 != null) {
            torsion = Point3.getTorsion(peucl3, p2.getEuclidPoint3(), p3.getEuclidPoint3(), p4.getEuclidPoint3()).getRadian();
        }
        return torsion;
    }

    public CMLPoint3 calculateFromInternalCoordinates(CMLPoint3 p2, CMLPoint3 p3, double length, double angle, double torsion) {
        Point3 peucl3 = this.getEuclidPoint3();
        Point3 pp = null;
        if (peucl3 != null) {
            try {
                pp = Point3.calculateFromInternalCoordinates(peucl3, p2.getEuclidPoint3(), p3.getEuclidPoint3(), length, new Angle(angle), new Angle(torsion));
            }
            catch (EuclidRuntimeException je) {
                throw new RuntimeException("bug " + je);
            }
        }
        return pp == null ? null : new CMLPoint3(pp);
    }

    public boolean isOrigin() {
        Point3 peucl3 = this.getEuclidPoint3();
        boolean ok = true;
        for (double d : peucl3.getArray()) {
            if (!(Math.abs(d) > 1.0E-14)) continue;
            ok = false;
            break;
        }
        return ok;
    }

    public String getString() {
        return this.getEuclidPoint3().toString();
    }
}

