/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerPEPEPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.PartialPiChargeDescriptorTest")
public class PartialPiChargeDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] names = new String[]{"pepe"};
    private GasteigerPEPEPartialCharges pepe = new GasteigerPEPEPartialCharges();
    private int maxIterations = -1;
    private int maxResonStruc = -1;
    private boolean lpeChecker = true;

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#partialPiCharge", this.getClass().getName(), "$Id: 0d8c4325bea33a46753af3c3d245db6e6576507c $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 3) {
            throw new CDKException("PartialPiChargeDescriptor only expects three parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
        if (params.length > 1 && params[1] != null) {
            if (!(params[1] instanceof Boolean)) {
                throw new CDKException("The parameter must be of type Boolean");
            }
            this.lpeChecker = (Boolean)params[1];
        }
        if (params.length > 2 && params[2] != null) {
            if (!(params[2] instanceof Integer)) {
                throw new CDKException("The parameter must be of type Integer");
            }
            this.maxResonStruc = (Integer)params[2];
        }
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations, this.lpeChecker, this.maxResonStruc};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), names, e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        Double originalCharge = atom.getCharge();
        String originalAtomtypeName = atom.getAtomTypeName();
        Integer originalNeighborCount = atom.getFormalNeighbourCount();
        Integer originalValency = atom.getValency();
        IAtomType.Hybridization originalHybridization = atom.getHybridization();
        if (!this.isCachedAtomContainer(ac)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
            if (this.lpeChecker) {
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                try {
                    lpcheck.saturate(ac);
                }
                catch (CDKException e) {
                    return this.getDummyDescriptorValue(e);
                }
            }
            if (this.maxIterations != -1) {
                this.pepe.setMaxGasteigerIters(this.maxIterations);
            }
            if (this.maxResonStruc != -1) {
                this.pepe.setMaxResoStruc(this.maxResonStruc);
            }
            try {
                int i;
                for (i = 0; i < ac.getAtomCount(); ++i) {
                    ac.getAtom(i).setCharge(0.0);
                }
                this.pepe.assignGasteigerPiPartialCharges(ac, true);
                for (i = 0; i < ac.getAtomCount(); ++i) {
                    this.cacheDescriptorValue(ac.getAtom(i), ac, new DoubleResult(ac.getAtom(i).getCharge()));
                }
            }
            catch (Exception exception) {
                return this.getDummyDescriptorValue(exception);
            }
        }
        atom.setCharge(originalCharge);
        atom.setAtomTypeName(originalAtomtypeName);
        atom.setFormalNeighbourCount(originalNeighborCount);
        atom.setValency(originalValency);
        atom.setHybridization(originalHybridization);
        return this.getCachedDescriptorValue(atom) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(atom), names) : null;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations", "lpeChecker", "maxResonStruc"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        if ("lpeChecker".equals(name)) {
            return Boolean.TRUE;
        }
        if ("maxResonStruc".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

