/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;

@TestClass(value="org.openscience.cdk.graph.SpanningTreeTest")
public class SpanningTree {
    private static final String ATOM_NUMBER = "ST_ATOMNO";
    private int[] parent = null;
    private int[][] cb = null;
    protected boolean[] bondsInTree;
    private int sptSize = 0;
    private int edrSize = 0;
    private int bondsAcyclicCount = 0;
    private int bondsCyclicCount = 0;
    private IAtomContainer molecule = null;
    private int totalEdgeCount = 0;
    private int totalVertexCount = 0;
    private boolean disconnected;
    private boolean identifiedBonds = false;

    @TestMethod(value="testIsDisconnected")
    public boolean isDisconnected() {
        return this.disconnected;
    }

    @TestMethod(value="testSpanningTree_IAtomContainer")
    public SpanningTree(IAtomContainer atomContainer) {
        this.buildSpanningTree(atomContainer);
    }

    private boolean fastfind(int v1, int v2, boolean union) {
        int t;
        int i = v1;
        while (this.parent[i] > 0) {
            i = this.parent[i];
        }
        int j = v2;
        while (this.parent[j] > 0) {
            j = this.parent[j];
        }
        while (this.parent[v1] > 0) {
            t = v1;
            v1 = this.parent[v1];
            this.parent[t] = i;
        }
        while (this.parent[v2] > 0) {
            t = v2;
            v2 = this.parent[v2];
            this.parent[t] = j;
        }
        if (union && i != j) {
            if (this.parent[j] < this.parent[i]) {
                this.parent[j] = this.parent[j] + this.parent[i] - 1;
                this.parent[i] = j;
            } else {
                this.parent[i] = this.parent[i] + this.parent[j] - 1;
                this.parent[j] = i;
            }
        }
        return i != j;
    }

    private void fastFindInit(int V) {
        this.parent = new int[V + 1];
        for (int i = 1; i <= V; ++i) {
            this.parent[i] = 0;
        }
    }

    private void buildSpanningTree(IAtomContainer atomContainer) {
        int b;
        this.disconnected = false;
        this.molecule = atomContainer;
        this.totalVertexCount = atomContainer.getAtomCount();
        this.totalEdgeCount = atomContainer.getBondCount();
        this.sptSize = 0;
        this.edrSize = 0;
        this.fastFindInit(this.totalVertexCount);
        for (int i = 0; i < this.totalVertexCount; ++i) {
            atomContainer.getAtom(i).setProperty(ATOM_NUMBER, Integer.toString(i + 1));
        }
        this.bondsInTree = new boolean[this.totalEdgeCount];
        for (b = 0; b < this.totalEdgeCount; ++b) {
            int v2;
            this.bondsInTree[b] = false;
            IBond bond = atomContainer.getBond(b);
            int v1 = Integer.parseInt(bond.getAtom(0).getProperty(ATOM_NUMBER).toString());
            if (this.fastfind(v1, v2 = Integer.parseInt(bond.getAtom(1).getProperty(ATOM_NUMBER).toString()), true)) {
                this.bondsInTree[b] = true;
                ++this.sptSize;
            }
            if (this.sptSize >= this.totalVertexCount - 1) break;
        }
        if (this.sptSize != this.totalVertexCount - 1) {
            this.disconnected = true;
        }
        for (b = 0; b < this.totalEdgeCount; ++b) {
            if (this.bondsInTree[b]) continue;
            ++this.edrSize;
        }
        this.cb = new int[this.edrSize][this.totalEdgeCount];
        for (int i = 0; i < this.edrSize; ++i) {
            for (int a = 0; a < this.totalEdgeCount; ++a) {
                this.cb[i][a] = 0;
            }
        }
        for (IAtom atom : atomContainer.atoms()) {
            atom.removeProperty(ATOM_NUMBER);
        }
    }

    @TestMethod(value="testGetSpanningTree")
    public IAtomContainer getSpanningTree() {
        IAtomContainer ac = this.molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int a = 0; a < this.totalVertexCount; ++a) {
            ac.addAtom(this.molecule.getAtom(a));
        }
        for (int b = 0; b < this.totalEdgeCount; ++b) {
            if (!this.bondsInTree[b]) continue;
            ac.addBond(this.molecule.getBond(b));
        }
        return ac;
    }

    @TestMethod(value="testGetPath_IAtomContainer_IAtom_IAtom")
    public IAtomContainer getPath(IAtomContainer spt, IAtom a1, IAtom a2) throws NoSuchAtomException {
        IAtomContainer path = spt.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        PathTools.resetFlags(spt);
        path.addAtom(a1);
        PathTools.depthFirstTargetSearch(spt, a1, a2, path);
        if (path.getAtomCount() == 1) {
            path.removeAtom(a1);
        }
        return path;
    }

    private IRing getRing(IAtomContainer spt, IBond bond) {
        IRing ring = spt.getBuilder().newInstance(IRing.class, new Object[0]);
        PathTools.resetFlags(spt);
        ring.addAtom(bond.getAtom(0));
        PathTools.depthFirstTargetSearch(spt, bond.getAtom(0), bond.getAtom(1), ring);
        ring.addBond(bond);
        return ring;
    }

    private void getBondsInRing(IAtomContainer mol, IRing ring, int[] bonds) {
        for (int i = 0; i < ring.getBondCount(); ++i) {
            int m = mol.getBondNumber(ring.getBond(i));
            bonds[m] = 1;
        }
    }

    @TestMethod(value="testGetBasicRings")
    public IRingSet getBasicRings() throws NoSuchAtomException {
        IRingSet ringset = this.molecule.getBuilder().newInstance(IRingSet.class, new Object[0]);
        IAtomContainer spt = this.getSpanningTree();
        for (int i = 0; i < this.totalEdgeCount; ++i) {
            if (this.bondsInTree[i]) continue;
            ringset.addAtomContainer(this.getRing(spt, this.molecule.getBond(i)));
        }
        return ringset;
    }

    @TestMethod(value="testGetCyclicFragmentsContainer")
    public IAtomContainer getCyclicFragmentsContainer() {
        IAtomContainer fragContainer = this.molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer spt = this.getSpanningTree();
        for (int i = 0; i < this.totalEdgeCount; ++i) {
            if (this.bondsInTree[i]) continue;
            IRing ring = this.getRing(spt, this.molecule.getBond(i));
            for (int b = 0; b < ring.getBondCount(); ++b) {
                IBond ringBond = ring.getBond(b);
                if (fragContainer.contains(ringBond)) continue;
                fragContainer.addBond(ringBond);
                for (int atomCount = 0; atomCount < ringBond.getAtomCount(); ++atomCount) {
                    IAtom atom = ringBond.getAtom(atomCount);
                    if (fragContainer.contains(atom)) continue;
                    atom.setFlag(1, true);
                    fragContainer.addAtom(atom);
                }
            }
        }
        return fragContainer;
    }

    private void identifyBonds() {
        int i;
        IAtomContainer spt = this.getSpanningTree();
        int nBasicRings = 0;
        for (i = 0; i < this.totalEdgeCount; ++i) {
            if (this.bondsInTree[i]) continue;
            IRing ring = this.getRing(spt, this.molecule.getBond(i));
            for (int b = 0; b < ring.getBondCount(); ++b) {
                int m = this.molecule.getBondNumber(ring.getBond(b));
                this.cb[nBasicRings][m] = 1;
            }
            ++nBasicRings;
        }
        this.bondsAcyclicCount = 0;
        this.bondsCyclicCount = 0;
        block6: for (i = 0; i < this.totalEdgeCount; ++i) {
            int s = 0;
            for (int j = 0; j < nBasicRings; ++j) {
                s += this.cb[j][i];
            }
            switch (s) {
                case 0: {
                    ++this.bondsAcyclicCount;
                    continue block6;
                }
                case 1: {
                    ++this.bondsCyclicCount;
                    continue block6;
                }
                default: {
                    ++this.bondsCyclicCount;
                }
            }
        }
        this.identifiedBonds = true;
    }

    @TestMethod(value="testGetAllRings")
    public IRingSet getAllRings() throws NoSuchAtomException {
        int i;
        IRingSet ringset = this.getBasicRings();
        int nBasicRings = ringset.getAtomContainerCount();
        for (i = 0; i < nBasicRings; ++i) {
            this.getBondsInRing(this.molecule, (IRing)ringset.getAtomContainer(i), this.cb[i]);
        }
        for (i = 0; i < nBasicRings; ++i) {
            for (int j = i + 1; j < nBasicRings; ++j) {
                IRing newring = this.combineRings(ringset, i, j);
                if (newring == null) continue;
                ringset.addAtomContainer(newring);
            }
        }
        return ringset;
    }

    @TestMethod(value="testGetSpanningTreeSize")
    public int getSpanningTreeSize() {
        return this.sptSize;
    }

    private IRing combineRings(IRingSet ringset, int i, int j) {
        int a;
        int c = 0;
        for (int b = 0; b < this.cb[i].length && (c = this.cb[i][b] + this.cb[j][b]) <= 1; ++b) {
        }
        if (c < 2) {
            return null;
        }
        IRing ring = this.molecule.getBuilder().newInstance(IRing.class, new Object[0]);
        IRing ring1 = (IRing)ringset.getAtomContainer(i);
        IRing ring2 = (IRing)ringset.getAtomContainer(j);
        for (int b = 0; b < this.cb[i].length; ++b) {
            c = this.cb[i][b] + this.cb[j][b];
            if (c == 1 && this.cb[i][b] == 1) {
                ring.addBond(this.molecule.getBond(b));
                continue;
            }
            if (c != 1 || this.cb[j][b] != 1) continue;
            ring.addBond(this.molecule.getBond(b));
        }
        for (a = 0; a < ring1.getAtomCount(); ++a) {
            ring.addAtom(ring1.getAtom(a));
        }
        for (a = 0; a < ring2.getAtomCount(); ++a) {
            ring.addAtom(ring2.getAtom(a));
        }
        return ring;
    }

    @TestMethod(value="testGetBondsAcyclicCount")
    public int getBondsAcyclicCount() {
        if (!this.identifiedBonds) {
            this.identifyBonds();
        }
        return this.bondsAcyclicCount;
    }

    @TestMethod(value="testGetBondsCyclicCount")
    public int getBondsCyclicCount() {
        if (!this.identifiedBonds) {
            this.identifyBonds();
        }
        return this.bondsCyclicCount;
    }
}

