/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.MannholdLogPDescriptorTest")
public class MannholdLogPDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"MLogP"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#mannholdLogP", this.getClass().getName(), "$Id: a7dbd2b4d7a6c5a8655395044adb4777d53afc21 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params != null && params.length > 0) {
            throw new CDKException("MannholdLogPDescriptor has no parameters.");
        }
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtomContainer ac = null;
        try {
            ac = (IAtomContainer)atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        int carbonCount = 0;
        int heteroCount = 0;
        for (IAtom atom : ac.atoms()) {
            if (Elements.HYDROGEN.getSymbol().equals(atom.getSymbol())) continue;
            if (Elements.CARBON.getSymbol().equals(atom.getSymbol())) {
                ++carbonCount;
                continue;
            }
            ++heteroCount;
        }
        double mLogP = 1.46 + 0.11 * (double)carbonCount - 0.11 * (double)heteroCount;
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(mLogP), this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

