/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.Lock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockMRSW
implements Lock {
    static Logger log = LoggerFactory.getLogger(LockMRSW.class);
    Map<Thread, LockState> threadStates = new HashMap<Thread, LockState>();
    int threadStatesSize = this.threadStates.size();
    ReadWriteLock mrswLock = new ReentrantReadWriteLock();
    AtomicInteger activeReadLocks = new AtomicInteger(0);
    AtomicInteger activeWriteLocks = new AtomicInteger(0);

    public LockMRSW() {
        if (log.isDebugEnabled()) {
            log.debug("Lock : " + Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterCriticalSection(boolean readLockRequested) {
        LockState state = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug(Thread.currentThread().getName() + " >> enterCS: " + this.report(state));
        }
        if (state.readLocks > 0 && state.writeLocks == 0 && !readLockRequested) {
            ++state.readLocks;
            this.activeReadLocks.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " << enterCS: promotion attempt: " + this.report(state));
            }
            throw new JenaException("enterCriticalSection: Write lock request while holding read lock - potential deadlock");
        }
        if (state.writeLocks > 0 && readLockRequested) {
            readLockRequested = false;
        }
        try {
            if (readLockRequested) {
                if (state.readLocks == 0) {
                    this.mrswLock.readLock().lock();
                }
                ++state.readLocks;
                this.activeReadLocks.incrementAndGet();
            } else {
                if (state.writeLocks == 0) {
                    this.mrswLock.writeLock().lock();
                }
                ++state.writeLocks;
                this.activeWriteLocks.incrementAndGet();
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " << enterCS: " + this.report(state));
            }
        }
    }

    public final void leaveCriticalSection() {
        LockState state = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug(Thread.currentThread().getName() + " >> leaveCS: " + this.report(state));
        }
        try {
            if (state.readLocks > 0) {
                --state.readLocks;
                this.activeReadLocks.getAndDecrement();
                if (state.readLocks == 0) {
                    this.mrswLock.readLock().unlock();
                }
                state.clean();
                return;
            }
            if (state.writeLocks > 0) {
                --state.writeLocks;
                this.activeWriteLocks.getAndDecrement();
                if (state.writeLocks == 0) {
                    this.mrswLock.writeLock().unlock();
                }
                state.clean();
                return;
            }
            throw new JenaException("leaveCriticalSection: No lock held (" + Thread.currentThread().getName() + ")");
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " << leaveCS: " + this.report(state));
            }
        }
    }

    private String report(LockState state) {
        StringBuffer sb = new StringBuffer();
        sb.append("Thread R/W: ");
        sb.append(Integer.toString(state.readLocks));
        sb.append("/");
        sb.append(Integer.toString(state.writeLocks));
        sb.append(" :: Model R/W: ");
        sb.append(Integer.toString(this.activeReadLocks.get()));
        sb.append("/");
        sb.append(Integer.toString(this.activeWriteLocks.get()));
        sb.append(" (thread: ");
        sb.append(state.thread.getName());
        sb.append(")");
        return sb.toString();
    }

    synchronized LockState getLockState() {
        Thread thisThread = Thread.currentThread();
        LockState state = this.threadStates.get(thisThread);
        if (state == null) {
            state = new LockState(this);
            this.threadStates.put(thisThread, state);
            this.threadStatesSize = this.threadStates.size();
        }
        return state;
    }

    synchronized void removeLockState(Thread thread) {
        this.threadStates.remove(thread);
    }

    static class LockState {
        int readLocks = 0;
        int writeLocks = 0;
        LockMRSW lock;
        Thread thread;

        LockState(LockMRSW theLock) {
            this.lock = theLock;
            this.thread = Thread.currentThread();
        }

        void clean() {
            if (this.lock.activeReadLocks.get() == 0 && this.lock.activeWriteLocks.get() == 0) {
                this.lock.removeLockState(this.thread);
            }
        }
    }
}

