/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.StandardSubstructureSets;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.SubstructureFingerprinterTest")
public class SubstructureFingerprinter
implements IFingerprinter {
    private String[] smarts;

    @TestMethod(value="testFingerprint")
    public SubstructureFingerprinter() {
        try {
            this.smarts = StandardSubstructureSets.getFunctionalGroupSMARTS();
        }
        catch (Exception e) {
            this.smarts = null;
        }
    }

    @TestMethod(value="testUserFunctionalGroups")
    public SubstructureFingerprinter(String[] smarts) {
        this.smarts = smarts;
    }

    @Override
    @TestMethod(value="testUserFunctionalGroups,testFingerprint")
    public BitSet getFingerprint(IAtomContainer atomContainer) throws CDKException {
        if (this.smarts == null) {
            throw new CDKException("No substructures were defined");
        }
        int bitsetLength = this.smarts.length;
        BitSet fingerPrint = new BitSet(bitsetLength);
        SMARTSQueryTool sqt = new SMARTSQueryTool("C");
        for (int i = 0; i < this.smarts.length; ++i) {
            String pattern = this.smarts[i];
            sqt.setSmarts(pattern);
            boolean status = sqt.matches(atomContainer);
            if (!status) continue;
            fingerPrint.set(i, true);
        }
        return fingerPrint;
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testSize")
    public int getSize() {
        return this.smarts.length;
    }

    @TestMethod(value="testGetSubstructure")
    public String getSubstructure(int bitIndex) {
        return this.smarts[bitIndex];
    }
}

