/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Comparator;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomContainerComparatorBy2DCenter
implements Comparator<IAtomContainer> {
    @Override
    public int compare(IAtomContainer atCont1, IAtomContainer atCont2) {
        if (atCont1 != null && atCont2 != null) {
            Point2d p1 = GeometryTools.get2DCenter(atCont1);
            Point2d p2 = GeometryTools.get2DCenter(atCont2);
            if (p1 != null && p2 != null) {
                if (p1.x != p2.x) {
                    return new Double(p1.x).compareTo(new Double(p2.x));
                }
                return new Double(p1.y).compareTo(new Double(p2.y));
            }
        }
        return 0;
    }
}

