/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.ArrayList;
import java.util.List;
import signature.SymmetryClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuotientGraph {
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private List<Edge> edges = new ArrayList<Edge>();

    public int getVertexCount() {
        return this.vertices.size();
    }

    public int getEdgeCount() {
        return this.edges.size();
    }

    public int numberOfLoopEdges() {
        int loopEdgeCount = 0;
        for (Edge e : this.edges) {
            if (!e.isLoop()) continue;
            ++loopEdgeCount;
        }
        return loopEdgeCount;
    }

    public abstract boolean isConnected(int var1, int var2);

    public List<String> getVertexSignatureStrings() {
        ArrayList<String> signatureStrings = new ArrayList<String>();
        for (Vertex vertex : this.vertices) {
            signatureStrings.add(vertex.signature);
        }
        return signatureStrings;
    }

    public void construct(List<SymmetryClass> symmetryClasses) {
        for (int i = 0; i < symmetryClasses.size(); ++i) {
            SymmetryClass symmetryClass = symmetryClasses.get(i);
            String signatureString = symmetryClass.getSignatureString();
            ArrayList<Integer> members = new ArrayList<Integer>();
            for (int e : symmetryClass) {
                members.add(e);
            }
            this.vertices.add(new Vertex(members, signatureString));
        }
        ArrayList<Edge> visitedEdges = new ArrayList<Edge>();
        for (int i = 0; i < symmetryClasses.size(); ++i) {
            SymmetryClass symmetryClass = symmetryClasses.get(i);
            for (int j = i; j < symmetryClasses.size(); ++j) {
                SymmetryClass otherSymmetryClass = symmetryClasses.get(j);
                int totalCount = 0;
                for (int x : symmetryClass) {
                    int countForX = 0;
                    for (int y : otherSymmetryClass) {
                        if (x == y || !this.isConnected(x, y) || this.inVisitedEdges(x, y, visitedEdges)) continue;
                        ++countForX;
                        visitedEdges.add(new Edge(x, y, 0));
                    }
                    totalCount += countForX;
                }
                if (totalCount <= 0) continue;
                this.edges.add(new Edge(i, j, totalCount));
            }
        }
    }

    private boolean inVisitedEdges(int x, int y, List<Edge> visitedEdges) {
        for (Edge edge : visitedEdges) {
            if ((edge.vertexIndexA != x || edge.vertexIndexB != y) && (edge.vertexIndexA != y || edge.vertexIndexB != x)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (Vertex vertex : this.vertices) {
            buffer.append(i).append(' ').append(vertex).append('\n');
            ++i;
        }
        buffer.append(this.edges);
        return buffer.toString();
    }

    private class Edge {
        public int count;
        public int vertexIndexA;
        public int vertexIndexB;

        public Edge(int vertexIndexA, int vertexIndexB, int count) {
            this.vertexIndexA = vertexIndexA;
            this.vertexIndexB = vertexIndexB;
            this.count = count;
        }

        public boolean isLoop() {
            return this.vertexIndexA == this.vertexIndexB;
        }

        public String toString() {
            return this.vertexIndexA + "-" + this.vertexIndexB + "(" + this.count + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Vertex {
        public List<Integer> members;
        public String signature;

        public Vertex(List<Integer> members, String signature) {
            this.members = members;
            this.signature = signature;
        }

        public String toString() {
            return this.signature + " " + this.members;
        }
    }
}

