/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.graph.AllPairsShortestPaths;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.layout.Congestion;
import org.openscience.cdk.layout.MacroCycleLayout;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

final class LayoutRefiner {
    private static final double BOND_LENGTH = 1.5;
    private static final double MIN_DIST = 0.75;
    private static final double MIN_SCORE = 1.7777777777777777;
    private static final double STRETCH_STEP = 0.48;
    private static final double BEND_STEP = Math.toRadians(10.0);
    private static final double MAX_BOND_LENGTH = 3.0;
    public static final double IMPROVEMENT_PERC_THRESHOLD = 0.02;
    public static final int ROTATE_DELTA_THRESHOLD = 5;
    private static final int MAX_ITERATIONS = 10;
    private final IAtomContainer mol;
    private final Map<IAtom, Integer> idxs;
    private final int[][] adjList;
    private final GraphUtil.EdgeToBondMap bondMap;
    private final IAtom[] atoms;
    private final Congestion congestion;
    private final AllPairsShortestPaths apsp;
    private final Point2d[] buffer1;
    private final Point2d[] buffer2;
    private final Point2d[] backup;
    private final IntStack stackBackup;
    private final boolean[] visited;
    private final int[] ringsystems;
    private final Set<IBond> probablySymmetric = new HashSet<IBond>();

    public LayoutRefiner(IAtomContainer mol) {
        this.mol = mol;
        this.bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(mol);
        this.adjList = GraphUtil.toAdjList(mol, this.bondMap);
        this.idxs = new HashMap<IAtom, Integer>();
        for (IAtom atom : mol.atoms()) {
            this.idxs.put(atom, this.idxs.size());
        }
        this.atoms = AtomContainerManipulator.getAtomArray(mol);
        this.buffer1 = new Point2d[this.atoms.length];
        this.buffer2 = new Point2d[this.atoms.length];
        this.backup = new Point2d[this.atoms.length];
        for (int i = 0; i < this.buffer1.length; ++i) {
            this.buffer1[i] = new Point2d();
            this.buffer2[i] = new Point2d();
            this.backup[i] = new Point2d();
        }
        this.stackBackup = new IntStack(this.atoms.length);
        this.visited = new boolean[this.atoms.length];
        this.congestion = new Congestion(mol, this.adjList);
        this.apsp = new AllPairsShortestPaths(mol);
        int rnum = 1;
        this.ringsystems = new int[this.atoms.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            if (!this.atoms[i].isInRing() || this.ringsystems[i] != 0) continue;
            this.traverseRing(this.ringsystems, i, rnum++);
        }
    }

    private void traverseRing(int[] ringSystem, int v, int rnum) {
        ringSystem[v] = rnum;
        for (int w : this.adjList[v]) {
            if (ringSystem[w] != 0 || !this.bondMap.get(v, w).isInRing()) continue;
            this.traverseRing(ringSystem, w, rnum);
        }
    }

    List<AtomPair> findCongestedPairs() {
        ArrayList<AtomPair> pairs = new ArrayList<AtomPair>();
        HashSet<IntTuple> ringpairs = new HashSet<IntTuple>();
        double maybeCrossed = 0.0;
        int numAtoms = this.mol.getAtomCount();
        for (int u = 0; u < numAtoms; ++u) {
            for (int v = u + 1; v < numAtoms; ++v) {
                int vWeight;
                int uWeight;
                int[] path;
                int len;
                double contribution = this.congestion.contribution(u, v);
                if (contribution <= 0.0 || this.ringsystems[u] > 0 && this.ringsystems[u] == this.ringsystems[v] || !(contribution >= 1.7777777777777777) && (!(contribution >= 0.0) || !this.haveCrossingBonds(u, v)) || (len = (path = (uWeight = ((Integer)this.mol.getAtom(u).getProperty("Weight")).intValue()) > (vWeight = ((Integer)this.mol.getAtom(v).getProperty("Weight")).intValue()) ? this.apsp.from(u).pathTo(v) : this.apsp.from(v).pathTo(u)).length) < 3) continue;
                int[] seqAt = new int[len - 2];
                IBond[] bndAt = new IBond[len - 1];
                this.makeAtmBndQueues(path, seqAt, bndAt);
                if (this.ringsystems[u] > 0 && this.ringsystems[v] > 0 && !ringpairs.add(new IntTuple(this.ringsystems[u], this.ringsystems[v]))) continue;
                pairs.add(new AtomPair(u, v, seqAt, bndAt));
            }
        }
        Collections.sort(pairs, new Comparator<AtomPair>(){

            @Override
            public int compare(AtomPair a, AtomPair b) {
                int bmax;
                int bmin;
                int amax;
                int amin;
                int a1 = (Integer)LayoutRefiner.this.atoms[a.fst].getProperty("Weight");
                int a2 = (Integer)LayoutRefiner.this.atoms[a.snd].getProperty("Weight");
                int b1 = (Integer)LayoutRefiner.this.atoms[b.fst].getProperty("Weight");
                int b2 = (Integer)LayoutRefiner.this.atoms[b.snd].getProperty("Weight");
                if (a1 < a2) {
                    amin = a1;
                    amax = a2;
                } else {
                    amin = a2;
                    amax = a1;
                }
                if (b1 < b2) {
                    bmin = a1;
                    bmax = a2;
                } else {
                    bmin = a2;
                    bmax = a1;
                }
                int cmp = Integer.compare(amin, bmin);
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(amax, bmax);
            }
        });
        return pairs;
    }

    private boolean isCrossed(Point2d beg1, Point2d end1, Point2d beg2, Point2d end2) {
        return Line2D.linesIntersect(beg1.x, beg1.y, end1.x, end1.y, beg2.x, beg2.y, end2.x, end2.y);
    }

    private boolean haveCrossingBonds(int u, int v) {
        int[] us = this.adjList[u];
        int[] vs = this.adjList[v];
        for (int u1 : us) {
            for (int v1 : vs) {
                if (u1 == v || v1 == u || u1 == v1 || !this.isCrossed(this.atoms[u].getPoint2d(), this.atoms[u1].getPoint2d(), this.atoms[v].getPoint2d(), this.atoms[v1].getPoint2d())) continue;
                return true;
            }
        }
        return false;
    }

    void rotate(Collection<AtomPair> pairs) {
        HashSet<IBond> tried = new HashSet<IBond>();
        block0: for (AtomPair pair2 : pairs) {
            for (IBond bond : pair2.bndAt) {
                if (!tried.add(bond) || this.probablySymmetric.contains(bond) || bond.getOrder() != IBond.Order.SINGLE || bond.isInRing()) continue;
                IAtom beg = bond.getAtom(0);
                IAtom end = bond.getAtom(1);
                int begIdx = this.idxs.get(beg);
                int endIdx = this.idxs.get(end);
                if (this.adjList[begIdx].length == 1 || this.adjList[endIdx].length == 1) continue;
                int begPriority = (Integer)beg.getProperty("Weight");
                int endPriority = (Integer)end.getProperty("Weight");
                Arrays.fill(this.visited, false);
                if (begPriority < endPriority) {
                    this.stackBackup.len = this.visitAdj(this.visited, this.stackBackup.xs, begIdx, endIdx);
                } else {
                    this.stackBackup.len = this.visitAdj(this.visited, this.stackBackup.xs, endIdx, begIdx);
                }
                double min = this.congestion.score();
                this.backupCoords(this.backup, this.stackBackup);
                this.reflect(this.stackBackup, beg, end);
                this.congestion.update(this.visited, this.stackBackup.xs, this.stackBackup.len);
                double delta = min - this.congestion.score();
                if (delta > 5.0 || delta > 1.0 && this.congestion.contribution(pair2.fst, pair2.snd) < 1.7777777777777777) continue block0;
                if (Math.abs(delta) < 0.1) {
                    this.probablySymmetric.add(bond);
                }
                this.restoreCoords(this.stackBackup, this.backup);
                this.congestion.update(this.visited, this.stackBackup.xs, this.stackBackup.len);
                this.congestion.score = min;
            }
        }
    }

    void invert(Collection<AtomPair> pairs) {
        for (AtomPair pair2 : pairs) {
            if (!(this.congestion.contribution(pair2.fst, pair2.snd) < 1.7777777777777777) && !this.fusionPointInversion(pair2) && !this.macroCycleInversion(pair2)) continue;
        }
    }

    private boolean macroCycleInversion(AtomPair pair2) {
        for (int v : pair2.seqAt) {
            IAtom atom = this.mol.getAtom(v);
            if (!atom.isInRing() || this.adjList[v].length == 2 || atom.getProperty(MacroCycleLayout.MACROCYCLE_ATOM_HINT) == null) continue;
            ArrayList<IBond> acyclic = new ArrayList<IBond>(2);
            ArrayList<IBond> cyclic = new ArrayList<IBond>(2);
            for (int w : this.adjList[v]) {
                IBond bond = this.bondMap.get(v, w);
                if (bond.isInRing()) {
                    cyclic.add(bond);
                    continue;
                }
                acyclic.add(bond);
            }
            if (cyclic.size() > 2) continue;
            Object object = acyclic.iterator();
            while (object.hasNext()) {
                IBond bond = (IBond)object.next();
                Arrays.fill(this.visited, false);
                this.stackBackup.len = this.visit(this.visited, this.stackBackup.xs, v, this.idxs.get(bond.getConnectedAtom(atom)), 0);
                Point2d a = atom.getPoint2d();
                Point2d b = bond.getConnectedAtom(atom).getPoint2d();
                Vector2d perp = new Vector2d(b.x - a.x, b.y - a.y);
                perp.normalize();
                double score = this.congestion.score();
                this.backupCoords(this.backup, this.stackBackup);
                this.reflect(this.stackBackup, new Point2d(a.x - perp.y, a.y + perp.x), new Point2d(a.x + perp.y, a.y - perp.x));
                this.congestion.update(this.visited, this.stackBackup.xs, this.stackBackup.len);
                if (LayoutRefiner.percDiff(score, this.congestion.score()) >= 0.02) {
                    return true;
                }
                this.restoreCoords(this.stackBackup, this.backup);
            }
        }
        return false;
    }

    private boolean fusionPointInversion(AtomPair pair2) {
        if (pair2.bndAt.length != 3) {
            return false;
        }
        if (!pair2.bndAt[0].isInRing() || pair2.bndAt[1].isInRing() || pair2.bndAt[2].isInRing()) {
            return false;
        }
        if (this.adjList[pair2.fst].length > 1 || this.adjList[pair2.snd].length > 1) {
            return false;
        }
        IAtom fst = this.atoms[pair2.fst];
        this.stackBackup.clear();
        if (fst.getAtomicNumber() == 1) {
            this.stackBackup.push(pair2.fst);
        } else {
            this.stackBackup.push(pair2.snd);
        }
        this.reflect(this.stackBackup, pair2.bndAt[0].getAtom(0), pair2.bndAt[0].getAtom(1));
        this.congestion.update(this.stackBackup.xs, this.stackBackup.len);
        return true;
    }

    private double bend(AtomPair pair2, IntStack stack, Point2d[] coords) {
        double score;
        this.stackBackup.clear();
        assert (stack.len == 0);
        double min = score = this.congestion.score();
        if (pair2.bndAt.length > 4 && (pair2.bndAtCode & 0x1F) == 6) {
            IBond bndA = pair2.bndAt[2];
            IBond bndB = pair2.bndAt[3];
            IAtom pivotA = LayoutRefiner.getCommon(bndA, pair2.bndAt[1]);
            IAtom pivotB = LayoutRefiner.getCommon(bndB, pair2.bndAt[0]);
            if (pivotA == null || pivotB == null) {
                return 2.147483647E9;
            }
            Arrays.fill(this.visited, false);
            int split = this.visit(this.visited, stack.xs, this.idxs.get(pivotA), this.idxs.get(bndA.getConnectedAtom(pivotA)), 0);
            stack.len = this.visit(this.visited, stack.xs, this.idxs.get(pivotB), this.idxs.get(bndB.getConnectedAtom(pivotB)), split);
            this.backupCoords(this.backup, stack);
            this.bend(stack.xs, 0, split, pivotA, BEND_STEP);
            this.bend(stack.xs, split, stack.len, pivotB, -BEND_STEP);
            this.congestion.update(stack.xs, stack.len);
            if (LayoutRefiner.percDiff(score, this.congestion.score()) >= 0.02) {
                this.backupCoords(coords, stack);
                this.stackBackup.copyFrom(stack);
                min = this.congestion.score();
            }
            this.restoreCoords(stack, this.backup);
            this.bend(stack.xs, 0, split, pivotA, -BEND_STEP);
            this.bend(stack.xs, split, stack.len, pivotB, BEND_STEP);
            this.congestion.update(stack.xs, stack.len);
            if (LayoutRefiner.percDiff(score, this.congestion.score()) >= 0.02 && this.congestion.score() < min) {
                this.backupCoords(coords, stack);
                this.stackBackup.copyFrom(stack);
                min = this.congestion.score();
            }
            this.restoreCoords(stack, this.backup);
            this.congestion.update(stack.xs, stack.len);
            this.congestion.score = score;
        } else {
            for (IBond bond : pair2.bndAt) {
                if (bond.isInRing()) continue;
                IAtom beg = bond.getAtom(0);
                IAtom end = bond.getAtom(1);
                int begPriority = (Integer)beg.getProperty("Weight");
                int endPriority = (Integer)end.getProperty("Weight");
                Arrays.fill(this.visited, false);
                if (begPriority < endPriority) {
                    stack.len = this.visit(this.visited, stack.xs, this.idxs.get(beg), this.idxs.get(end), 0);
                } else {
                    stack.len = this.visit(this.visited, stack.xs, this.idxs.get(end), this.idxs.get(beg), 0);
                }
                this.backupCoords(this.backup, stack);
                if (begPriority < endPriority) {
                    this.bend(stack.xs, 0, stack.len, beg, (double)pair2.attempt * BEND_STEP);
                } else {
                    this.bend(stack.xs, 0, stack.len, end, (double)pair2.attempt * BEND_STEP);
                }
                this.congestion.update(this.visited, stack.xs, stack.len);
                if (LayoutRefiner.percDiff(score, this.congestion.score()) >= 0.02 && this.congestion.score() < min) {
                    this.backupCoords(coords, stack);
                    this.stackBackup.copyFrom(stack);
                    min = this.congestion.score();
                }
                if (begPriority < endPriority) {
                    this.bend(stack.xs, 0, stack.len, beg, (double)pair2.attempt * -BEND_STEP);
                } else {
                    this.bend(stack.xs, 0, stack.len, end, (double)pair2.attempt * -BEND_STEP);
                }
                this.congestion.update(this.visited, stack.xs, stack.len);
                if (LayoutRefiner.percDiff(score, this.congestion.score()) >= 0.02 && this.congestion.score() < min) {
                    this.backupCoords(coords, stack);
                    this.stackBackup.copyFrom(stack);
                    min = this.congestion.score();
                }
                this.restoreCoords(stack, this.backup);
                this.congestion.update(this.visited, stack.xs, stack.len);
                this.congestion.score = score;
            }
        }
        stack.copyFrom(this.stackBackup);
        return min;
    }

    private double stretch(AtomPair pair2, IntStack stack, Point2d[] coords) {
        double score;
        this.stackBackup.clear();
        double min = score = this.congestion.score();
        for (IBond bond : pair2.bndAt) {
            if (bond.isInRing()) continue;
            IAtom beg = bond.getAtom(0);
            IAtom end = bond.getAtom(1);
            int begIdx = this.idxs.get(beg);
            int endIdx = this.idxs.get(end);
            int begPriority = (Integer)beg.getProperty("Weight");
            int endPriority = (Integer)end.getProperty("Weight");
            Arrays.fill(this.visited, false);
            if (begPriority < endPriority) {
                stack.len = this.visit(this.visited, stack.xs, endIdx, begIdx, 0);
            } else {
                stack.len = this.visit(this.visited, stack.xs, begIdx, endIdx, 0);
            }
            this.backupCoords(this.backup, stack);
            if (begPriority < endPriority) {
                this.stretch(stack, end, beg, (double)pair2.attempt * 0.48);
            } else {
                this.stretch(stack, beg, end, (double)pair2.attempt * 0.48);
            }
            this.congestion.update(this.visited, stack.xs, stack.len);
            if (LayoutRefiner.percDiff(score, this.congestion.score()) >= 0.02 && this.congestion.score() < min) {
                this.backupCoords(coords, stack);
                min = this.congestion.score();
                this.stackBackup.copyFrom(stack);
            }
            this.restoreCoords(stack, this.backup);
            this.congestion.update(this.visited, stack.xs, stack.len);
            this.congestion.score = score;
        }
        stack.copyFrom(this.stackBackup);
        return min;
    }

    private void bendOrStretch(Collection<AtomPair> pairs) {
        IntStack bendStack = new IntStack(this.atoms.length);
        IntStack stretchStack = new IntStack(this.atoms.length);
        block0: for (AtomPair pair2 : pairs) {
            double score = this.congestion.score();
            pair2.attempt = 1;
            while (pair2.attempt <= 3) {
                bendStack.clear();
                stretchStack.clear();
                double bendScore = this.bend(pair2, bendStack, this.buffer1);
                double stretchScore = this.stretch(pair2, stretchStack, this.buffer2);
                if (bendScore < stretchScore && bendScore < score) {
                    this.restoreCoords(bendStack, this.buffer1);
                    this.congestion.update(bendStack.xs, bendStack.len);
                    continue block0;
                }
                if (bendScore > stretchScore && stretchScore < score) {
                    this.restoreCoords(stretchStack, this.buffer2);
                    this.congestion.update(stretchStack.xs, stretchStack.len);
                    continue block0;
                }
                ++pair2.attempt;
            }
        }
    }

    public void refine() {
        List<AtomPair> pairs;
        for (int i = 1; i <= 10 && !(pairs = this.findCongestedPairs()).isEmpty(); ++i) {
            double min = this.congestion.score();
            this.rotate(pairs);
            if (this.congestion.score() < min) continue;
            this.invert(pairs);
            if (this.congestion.score() < min) continue;
            this.bendOrStretch(pairs);
            if (!(this.congestion.score() < min)) break;
        }
    }

    private void backupCoords(Point2d[] dest, IntStack stack) {
        for (int i = 0; i < stack.len; ++i) {
            int v = stack.xs[i];
            dest[v].x = this.atoms[v].getPoint2d().x;
            dest[v].y = this.atoms[v].getPoint2d().y;
        }
    }

    private void restoreCoords(IntStack stack, Point2d[] src) {
        for (int i = 0; i < stack.len; ++i) {
            int v = stack.xs[i];
            this.atoms[v].getPoint2d().x = src[v].x;
            this.atoms[v].getPoint2d().y = src[v].y;
        }
    }

    private void reflect(IntStack stack, IAtom beg, IAtom end) {
        Point2d begP = beg.getPoint2d();
        Point2d endP = end.getPoint2d();
        this.reflect(stack, begP, endP);
    }

    private void reflect(IntStack stack, Tuple2d begP, Tuple2d endP) {
        double dx = endP.x - begP.x;
        double dy = endP.y - begP.y;
        double a = (dx * dx - dy * dy) / (dx * dx + dy * dy);
        double b = 2.0 * dx * dy / (dx * dx + dy * dy);
        for (int i = 0; i < stack.len; ++i) {
            LayoutRefiner.reflect(this.atoms[stack.xs[i]].getPoint2d(), begP, a, b);
        }
    }

    private static void reflect(Tuple2d p, Tuple2d base, double a, double b) {
        double x = a * (p.x - base.x) + b * (p.y - base.y) + base.x;
        double y = b * (p.x - base.x) - a * (p.y - base.y) + base.y;
        p.x = x;
        p.y = y;
    }

    private void bend(int[] indexes, int from, int to, IAtom pivotAtm, double r) {
        double s = Math.sin(r);
        double c = Math.cos(r);
        Point2d pivot = pivotAtm.getPoint2d();
        for (int i = from; i < to; ++i) {
            Point2d p = this.mol.getAtom(indexes[i]).getPoint2d();
            double x = p.x - pivot.x;
            double y = p.y - pivot.y;
            double nx = x * c + y * s;
            double ny = -x * s + y * c;
            p.x = nx + pivot.x;
            p.y = ny + pivot.y;
        }
    }

    private void stretch(IntStack stack, IAtom beg, IAtom end, double amount) {
        Point2d endPoint;
        Point2d begPoint = beg.getPoint2d();
        if (begPoint.distance(endPoint = end.getPoint2d()) + amount > 3.0) {
            return;
        }
        Vector2d vector = new Vector2d(endPoint.x - begPoint.x, endPoint.y - begPoint.y);
        vector.normalize();
        vector.scale(amount);
        for (int i = 0; i < stack.len; ++i) {
            this.atoms[stack.xs[i]].getPoint2d().add(vector);
        }
    }

    private void makeAtmBndQueues(int[] path, int[] seqAt, IBond[] bndAt) {
        int len = path.length;
        int i = (len - 1) / 2;
        int j = i + 1;
        int nSeqAt = 0;
        int nBndAt = 0;
        if (LayoutRefiner.isOdd(path.length)) {
            seqAt[nSeqAt++] = path[i--];
            bndAt[nBndAt++] = this.bondMap.get(path[j], path[j - 1]);
        }
        bndAt[nBndAt++] = this.bondMap.get(path[i], path[i + 1]);
        while (i > 0 && j < len - 1) {
            seqAt[nSeqAt++] = path[i--];
            seqAt[nSeqAt++] = path[j++];
            bndAt[nBndAt++] = this.bondMap.get(path[i], path[i + 1]);
            bndAt[nBndAt++] = this.bondMap.get(path[j], path[j - 1]);
        }
    }

    private static boolean isOdd(int len) {
        return (len & 1) != 0;
    }

    private static double percDiff(double prev, double curr) {
        return (prev - curr) / prev;
    }

    private int visitAdj(boolean[] visited, int[] result, int p, int v) {
        int n = 0;
        Arrays.fill(visited, false);
        visited[v] = true;
        for (int w : this.adjList[v]) {
            if (w == p || visited[w]) continue;
            n = this.visit(visited, result, v, w, n);
        }
        visited[v] = false;
        return n;
    }

    private int visit(boolean[] visited, int[] result, int p, int v, int n) {
        visited[v] = true;
        result[n++] = v;
        for (int w : this.adjList[v]) {
            if (w == p || visited[w]) continue;
            n = this.visit(visited, result, v, w, n);
        }
        return n;
    }

    private static IAtom getCommon(IBond bndA, IBond bndB) {
        IAtom beg = bndA.getAtom(0);
        IAtom end = bndA.getAtom(1);
        if (bndB.contains(beg)) {
            return beg;
        }
        if (bndB.contains(end)) {
            return end;
        }
        return null;
    }

    private static final class IntTuple {
        private final int fst;
        private final int snd;

        public IntTuple(int fst, int snd) {
            this.fst = fst;
            this.snd = snd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntTuple that = (IntTuple)o;
            return this.fst == that.fst && this.snd == that.snd || this.fst == that.snd && this.snd == that.fst;
        }

        public int hashCode() {
            return this.fst ^ this.snd;
        }
    }

    private static final class IntStack {
        private final int[] xs;
        private int len;

        public IntStack(int cap) {
            this.xs = new int[cap];
        }

        void push(int x) {
            this.xs[this.len++] = x;
        }

        void clear() {
            this.len = 0;
        }

        void copyFrom(IntStack stack) {
            System.arraycopy(stack.xs, 0, this.xs, 0, stack.len);
            this.len = stack.len;
        }

        public String toString() {
            return Arrays.toString(Arrays.copyOf(this.xs, this.len));
        }
    }

    private static final class AtomPair {
        final int fst;
        final int snd;
        final int[] seqAt;
        final IBond[] bndAt;
        final int bndAtCode;
        int attempt = 1;

        public AtomPair(int fst, int snd, int[] seqAt, IBond[] bndAt) {
            this.fst = fst;
            this.snd = snd;
            this.seqAt = seqAt;
            this.bndAt = bndAt;
            this.bndAtCode = AtomPair.bndCode(bndAt);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtomPair pair2 = (AtomPair)o;
            return this.fst == pair2.fst && this.snd == pair2.snd || this.fst == pair2.snd && this.snd == pair2.fst;
        }

        public int hashCode() {
            return this.fst ^ this.snd;
        }

        static int bndCode(IBond[] bonds) {
            int code = bonds.length & 1;
            for (int i = 0; i < bonds.length; ++i) {
                if (!bonds[i].isInRing()) continue;
                code |= 1 << i + 1;
            }
            return code;
        }
    }
}

