/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import java.util.Arrays;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;

public class PharmacophoreAtom
extends Atom {
    private String smarts;
    private int[] matchingAtoms;

    public PharmacophoreAtom(String smarts, String symbol, Point3d coordinates) {
        this.smarts = smarts;
        this.symbol = symbol;
        this.setPoint3d(coordinates);
    }

    public PharmacophoreAtom(PharmacophoreAtom pharmacophoreAtom) {
        this.smarts = pharmacophoreAtom.getSmarts();
        this.symbol = pharmacophoreAtom.getSymbol();
        this.setPoint3d(new Point3d(pharmacophoreAtom.getPoint3d()));
        if (pharmacophoreAtom.getMatchingAtoms() != null) {
            int[] indices = pharmacophoreAtom.getMatchingAtoms();
            this.matchingAtoms = new int[indices.length];
            System.arraycopy(indices, 0, this.matchingAtoms, 0, indices.length);
        }
    }

    public void setSmarts(String smarts) {
        this.smarts = smarts;
    }

    public String getSmarts() {
        return this.smarts;
    }

    public void setMatchingAtoms(int[] atomIndices) {
        this.matchingAtoms = new int[atomIndices.length];
        System.arraycopy(atomIndices, 0, this.matchingAtoms, 0, atomIndices.length);
        Arrays.sort(this.matchingAtoms);
    }

    public int[] getMatchingAtoms() {
        return this.matchingAtoms;
    }

    public int hashCode() {
        int result = this.smarts != null ? this.smarts.hashCode() : 0;
        result = 31 * result + (this.matchingAtoms != null ? Arrays.hashCode(this.matchingAtoms) : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PharmacophoreAtom)) {
            return false;
        }
        PharmacophoreAtom that = (PharmacophoreAtom)o;
        return this.smarts.equals(that.getSmarts()) && this.symbol.equals(that.getSymbol()) && this.point3d.equals(that.getPoint3d()) && Arrays.equals(this.matchingAtoms, that.matchingAtoms);
    }
}

