/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.tools.CDKHydrogenAdder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smiles.FixBondOrdersToolTest")
public class FixBondOrdersTool {
    private boolean interrupted;

    @TestMethod(value="testLargeRingSystem")
    public IAtomContainer kekuliseAromaticRings(IAtomContainer molecule) throws CDKException {
        IRingSet ringSet;
        IAtomContainer mNew = null;
        try {
            mNew = molecule.clone();
        }
        catch (Exception e) {
            throw new CDKException("Failed to clone source molecule");
        }
        try {
            ringSet = this.removeExtraRings(mNew);
        }
        catch (CDKException x) {
            throw x;
        }
        catch (Exception x) {
            throw new CDKException("failure in SSSRFinder.findAllRings", x);
        }
        if (ringSet == null) {
            throw new CDKException("failure in SSSRFinder.findAllRings");
        }
        List<Integer[]> rBondsArray = null;
        List<List<Integer>> ringGroups = null;
        rBondsArray = this.getRingSystem(mNew, ringSet);
        ringGroups = this.assignRingGroups(rBondsArray);
        for (int i = 0; i < ringGroups.size(); ++i) {
            int j;
            this.setAllRingBondsSingleOrder(ringGroups.get(i), ringSet);
            List<Integer> atomNos = null;
            atomNos = this.getAtomNosForRingGroup(mNew, ringGroups.get(i), ringSet);
            List<Integer> bondNos = null;
            bondNos = this.getBondNosForRingGroup(mNew, ringGroups.get(i), ringSet);
            List<Integer[]> atomNoPairs = null;
            atomNoPairs = this.getAtomNoPairsForRingGroup(mNew, bondNos);
            Matrix M = new Matrix(atomNos.size(), bondNos.size());
            for (int x = 0; x < M.getRows(); ++x) {
                for (int y = 0; y < M.getCols(); ++y) {
                    if (atomNos.get(x) == atomNoPairs.get(y)[0]) {
                        M.set(x, y, 1);
                        continue;
                    }
                    if (atomNos.get(x) == atomNoPairs.get(y)[1]) {
                        M.set(x, y, 1);
                        continue;
                    }
                    M.set(x, y, 0);
                }
            }
            List<Integer> freeValencies = null;
            freeValencies = this.getFreeValenciesForRingGroup(mNew, atomNos, M, ringSet);
            ArrayList<Integer> bondOrders = new ArrayList<Integer>();
            for (j = 0; j < bondNos.size(); ++j) {
                bondOrders.add(0);
            }
            if (!this.solveMatrix(M, atomNos, bondNos, freeValencies, atomNoPairs, bondOrders).booleanValue()) continue;
            for (j = 0; j < bondOrders.size(); ++j) {
                mNew.getBond(bondNos.get(j)).setOrder((Integer)bondOrders.get(j) == 1 ? IBond.Order.SINGLE : IBond.Order.DOUBLE);
            }
        }
        return mNew;
    }

    private IRingSet removeExtraRings(IAtomContainer m) throws Exception {
        SSSRFinder arf = new SSSRFinder(m);
        IRingSet rs = arf.findSSSR();
        Iterator<IAtomContainer> i = rs.atomContainers().iterator();
        block0: while (i.hasNext()) {
            IRing r = (IRing)i.next();
            if (r.getAtomCount() > 8) {
                i.remove();
                continue;
            }
            for (IAtom a : r.atoms()) {
                IAtomType.Hybridization h = a.getHybridization();
                if (h != CDKConstants.UNSET && (h == IAtomType.Hybridization.SP2 || h == IAtomType.Hybridization.PLANAR3)) continue;
                i.remove();
                continue block0;
            }
        }
        return rs;
    }

    private List<Integer[]> getRingSystem(IAtomContainer mol, IRingSet ringSet) {
        ArrayList<Integer[]> bondsArray = new ArrayList<Integer[]>();
        for (int r = 0; r < ringSet.getAtomContainerCount(); ++r) {
            IRing ring = (IRing)ringSet.getAtomContainer(r);
            Integer[] bondNumbers = new Integer[ring.getBondCount()];
            for (int i = 0; i < ring.getBondCount(); ++i) {
                bondNumbers[i] = mol.getBondNumber(ring.getBond(i));
            }
            bondsArray.add(bondNumbers);
        }
        return bondsArray;
    }

    private List<List<Integer>> assignRingGroups(List<Integer[]> rBondsArray) {
        int i;
        ArrayList<List<Integer>> ringGroups = new ArrayList<List<Integer>>();
        for (i = 0; i < rBondsArray.size() - 1; ++i) {
            for (int j = 0; j < rBondsArray.get(i).length; ++j) {
                for (int k = i + 1; k < rBondsArray.size(); ++k) {
                    for (int l = 0; l < rBondsArray.get(k).length; ++l) {
                        if (rBondsArray.get(i)[j] != rBondsArray.get(k)[l] || i == k) continue;
                        ringGroups.add(new ArrayList());
                        ((List)ringGroups.get(ringGroups.size() - 1)).add(i);
                        ((List)ringGroups.get(ringGroups.size() - 1)).add(k);
                    }
                }
            }
        }
        while (this.combineGroups(ringGroups).booleanValue()) {
        }
        for (i = 0; i < rBondsArray.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < ringGroups.size(); ++j) {
                if (!((List)ringGroups.get(j)).contains(i)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ringGroups.add(new ArrayList());
            ((List)ringGroups.get(ringGroups.size() - 1)).add(i);
        }
        return ringGroups;
    }

    private Boolean combineGroups(List<List<Integer>> ringGroups) {
        for (int i = 0; i < ringGroups.size() - 1; ++i) {
            for (int j = i + 1; j < ringGroups.size(); ++j) {
                for (int k = 0; k < ringGroups.get(j).size(); ++k) {
                    if (!ringGroups.get(i).contains(ringGroups.get(j).get(k))) continue;
                    for (int l = 0; l < ringGroups.get(j).size(); ++l) {
                        if (ringGroups.get(i).contains(ringGroups.get(j).get(l))) continue;
                        ringGroups.get(i).add(ringGroups.get(j).get(l));
                    }
                    ringGroups.remove(j);
                    return true;
                }
            }
        }
        return false;
    }

    private Boolean setAllRingBondsSingleOrder(List<Integer> ringGroup, IRingSet ringSet) {
        for (Integer i : ringGroup) {
            for (IBond bond : ringSet.getAtomContainer(i).bonds()) {
                bond.setOrder(IBond.Order.SINGLE);
            }
        }
        return true;
    }

    private List<Integer> getAtomNosForRingGroup(IAtomContainer molecule, List<Integer> ringGroup, IRingSet ringSet) {
        ArrayList<Integer> atc = new ArrayList<Integer>();
        for (Integer i : ringGroup) {
            for (IAtom atom : ringSet.getAtomContainer(i).atoms()) {
                if (atc.size() > 0) {
                    if (atc.contains(molecule.getAtomNumber(atom))) continue;
                    atc.add(molecule.getAtomNumber(atom));
                    continue;
                }
                atc.add(molecule.getAtomNumber(atom));
            }
        }
        return atc;
    }

    private List<Integer> getBondNosForRingGroup(IAtomContainer molecule, List<Integer> ringGroup, IRingSet ringSet) {
        ArrayList<Integer> btc = new ArrayList<Integer>();
        for (Integer i : ringGroup) {
            for (IBond bond : ringSet.getAtomContainer(i).bonds()) {
                if (btc.size() > 0) {
                    if (btc.contains(molecule.getBondNumber(bond))) continue;
                    btc.add(molecule.getBondNumber(bond));
                    continue;
                }
                btc.add(molecule.getBondNumber(bond));
            }
        }
        return btc;
    }

    private List<Integer[]> getAtomNoPairsForRingGroup(IAtomContainer molecule, List<Integer> bondsToCheck) {
        ArrayList<Integer[]> aptc = new ArrayList<Integer[]>();
        for (Integer i : bondsToCheck) {
            Integer[] aps = new Integer[]{molecule.getAtomNumber(molecule.getBond(i).getAtom(0)), molecule.getAtomNumber(molecule.getBond(i).getAtom(1))};
            aptc.add(aps);
        }
        return aptc;
    }

    private List<Integer> getFreeValenciesForRingGroup(IAtomContainer molecule, List<Integer> atomsToCheck, Matrix M, IRingSet rs) {
        ArrayList<Integer> fvtc = new ArrayList<Integer>();
        for (int i = 0; i < atomsToCheck.size(); ++i) {
            int j = atomsToCheck.get(i);
            if ("C".equals(molecule.getAtom(j).getSymbol()) && molecule.getAtom(j).getHybridization() == IAtomType.Hybridization.PLANAR3) {
                for (IAtomContainer ac : rs.atomContainers()) {
                    if (!ac.contains(molecule.getAtom(j)) || (int)molecule.getBondOrderSum(molecule.getAtom(j)) != 2 || ac.getAtomCount() != 5) continue;
                    molecule.getAtom(j).setImplicitHydrogenCount(1);
                    break;
                }
            }
            int implicitH = 0;
            if (molecule.getAtom(j).getImplicitHydrogenCount() == null) {
                CDKHydrogenAdder ha = CDKHydrogenAdder.getInstance(molecule.getBuilder());
                try {
                    ha.addImplicitHydrogens(molecule, molecule.getAtom(j));
                    implicitH = molecule.getAtom(j).getImplicitHydrogenCount();
                }
                catch (CDKException e) {}
            } else {
                implicitH = molecule.getAtom(j).getImplicitHydrogenCount();
            }
            fvtc.add(molecule.getAtom(j).getValency() - (implicitH + (int)molecule.getBondOrderSum(molecule.getAtom(j))) + M.sumOfRow(i));
        }
        return fvtc;
    }

    private Boolean solveMatrix(Matrix M, List<Integer> atomNos, List<Integer> bondNos, List<Integer> freeValencies, List<Integer[]> atomNoPairs, List<Integer> bondOrder) {
        int j;
        int k;
        ArrayList<Integer> solved = new ArrayList<Integer>();
        ArrayList<Integer> solvedRow = new ArrayList<Integer>();
        for (int j2 = 0; j2 < atomNos.size(); ++j2) {
            int k2;
            int sumOfRow = M.sumOfRow(j2);
            if (sumOfRow == freeValencies.get(j2)) {
                for (k2 = 0; k2 < bondNos.size(); ++k2) {
                    if (M.get(j2, k2) != 1) continue;
                    bondOrder.set(k2, 1);
                    solved.add(k2);
                }
                solvedRow.add(j2);
                continue;
            }
            if (sumOfRow != 1) continue;
            for (k2 = 0; k2 < bondNos.size(); ++k2) {
                if (M.get(j2, k2) != 1) continue;
                bondOrder.set(k2, freeValencies.get(j2));
                solved.add(k2);
            }
            solvedRow.add(j2);
        }
        boolean thisRun = true;
        while (solvedRow.size() != M.getRows().intValue() && thisRun) {
            thisRun = false;
            if (solved.size() > 0) {
                for (int j3 = 0; j3 < M.getRows(); ++j3) {
                    if (solvedRow.contains(j3)) continue;
                    int unknownBonds = 0;
                    int knownBondTotal = 0;
                    for (k = 0; k < bondNos.size(); ++k) {
                        if (M.get(j3, k) != 1) continue;
                        if (solved.contains(k)) {
                            knownBondTotal += bondOrder.get(k).intValue();
                            continue;
                        }
                        ++unknownBonds;
                    }
                    if (unknownBonds == 0) {
                        solvedRow.add(j3);
                        thisRun = true;
                        continue;
                    }
                    if (knownBondTotal == 0) continue;
                    if (unknownBonds == freeValencies.get(j3) - knownBondTotal) {
                        for (k = 0; k < bondNos.size(); ++k) {
                            if (M.get(j3, k) != 1 || solved.contains(k)) continue;
                            bondOrder.set(k, 1);
                            solved.add(k);
                        }
                        solvedRow.add(j3);
                        thisRun = true;
                        continue;
                    }
                    if (unknownBonds != 1) continue;
                    for (k = 0; k < bondNos.size(); ++k) {
                        if (M.get(j3, k) != 1 || solved.contains(k)) continue;
                        bondOrder.set(k, freeValencies.get(j3) - knownBondTotal);
                        solved.add(k);
                    }
                    solvedRow.add(j3);
                    thisRun = true;
                }
            }
            if (thisRun) continue;
            boolean ring = true;
            for (j = 0; ring && j < bondNos.size(); ++j) {
                boolean badChoice = false;
                if (solvedRow.contains(atomNos.indexOf(atomNoPairs.get(j)[0]))) {
                    badChoice = true;
                }
                if (solvedRow.contains(atomNos.indexOf(atomNoPairs.get(j)[1]))) {
                    badChoice = true;
                }
                if (bondOrder.get(j) != 0 || badChoice) continue;
                bondOrder.set(j, 1);
                ring = false;
                thisRun = true;
                solved.add(j);
            }
        }
        if (solvedRow.size() != M.getRows().intValue()) {
            return false;
        }
        boolean errorFound = false;
        for (j = 0; j < atomNos.size(); ++j) {
            int checker = 0;
            for (k = 0; k < bondNos.size(); ++k) {
                checker += M.get(j, k) * bondOrder.get(k);
            }
            if (checker == freeValencies.get(j)) continue;
            errorFound = true;
        }
        if (errorFound) {
            return false;
        }
        return true;
    }

    @TestMethod(value="testInterruption")
    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    @TestMethod(value="testInterruption")
    public boolean isInterrupted() {
        return this.interrupted;
    }

    private static class Matrix {
        private int[] mArray;
        private int rowCount;
        private int columnCount;

        public Matrix(Integer rows, Integer cols) {
            this.mArray = new int[rows * cols];
            this.rowCount = rows;
            this.columnCount = cols;
        }

        public void set(Integer rIndex, Integer cIndex, Integer val) {
            this.mArray[rIndex.intValue() * this.columnCount + cIndex.intValue()] = val;
        }

        public Integer get(Integer rIndex, Integer cIndex) {
            return this.mArray[rIndex * this.columnCount + cIndex];
        }

        public Integer colIndexOf(Integer colIndex, Integer val) {
            for (int i = 0; i < this.rowCount; ++i) {
                if (this.mArray[i * this.columnCount + colIndex] != val) continue;
                return i;
            }
            return -1;
        }

        public Integer rowIndexOf(Integer rowIndex, Integer val) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.mArray[rowIndex * this.getCols() + i] != val) continue;
                return i;
            }
            return -1;
        }

        public Integer sumOfRow(Integer rowIndex) {
            Integer sumOfRow = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                sumOfRow = sumOfRow + this.mArray[rowIndex * this.columnCount + i];
            }
            return sumOfRow;
        }

        public Integer getRows() {
            return this.rowCount;
        }

        public Integer getCols() {
            return this.columnCount;
        }
    }
}

