/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.charges.ElectronegativityTest")
public class Electronegativity {
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private int maxI = 6;
    private int maxRS = 50;
    private IAtomContainer molSigma;
    private IAtomContainer acOldS;
    private double[] marsiliFactors;

    public Electronegativity() {
        this(6, 50);
    }

    public Electronegativity(int maxIterations, int maxResonStruc) {
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
    }

    @TestMethod(value="testCalculateSigmaElectronegativity_IAtomContainer_IAtom")
    public double calculateSigmaElectronegativity(IAtomContainer ac, IAtom atom) {
        return this.calculateSigmaElectronegativity(ac, atom, this.maxI, this.maxRS);
    }

    @TestMethod(value="testCalculateSigmaElectronegativity_IAtomContainer_IAtom_Int_Int")
    public double calculateSigmaElectronegativity(IAtomContainer ac, IAtom atom, int maxIterations, int maxResonStruc) {
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
        double electronegativity = 0.0;
        try {
            if (!ac.equals(this.acOldS)) {
                this.molSigma = ac.getBuilder().newInstance(IAtomContainer.class, ac);
                this.peoe.setMaxGasteigerIters(this.maxI);
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(this.molSigma, true);
                this.marsiliFactors = this.peoe.assignGasteigerSigmaMarsiliFactors(this.molSigma);
                this.acOldS = ac;
            }
            int stepSize = this.peoe.getStepSize();
            int atomPosition = ac.getAtomNumber(atom);
            int start = stepSize * atomPosition + atomPosition;
            electronegativity = this.marsiliFactors[start] + this.molSigma.getAtom(atomPosition).getCharge() * this.marsiliFactors[start + 1] + this.marsiliFactors[start + 2] * (this.molSigma.getAtom(atomPosition).getCharge() * this.molSigma.getAtom(atomPosition).getCharge());
            return electronegativity;
        }
        catch (Exception e) {
            e.printStackTrace();
            return electronegativity;
        }
    }

    @TestMethod(value="testSetMaxIterations_Int")
    public void setMaxIterations(int maxIterations) {
        this.maxI = maxIterations;
    }

    @TestMethod(value="testSetMaxResonStruc_Int")
    public void setMaxResonStruc(int maxResonStruc) {
        this.maxRS = maxResonStruc;
    }

    @TestMethod(value="testGetMaxIterations")
    public int getMaxIterations() {
        return this.maxI;
    }

    @TestMethod(value="testGetMaxResonStruc")
    public int getMaxResonStruc() {
        return this.maxRS;
    }
}

